/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.Container;
import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStore;
import io.fabric8.api.DataStoreRegistrationHandler;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.EnsembleModificationFailed;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ZooKeeperClusterBootstrap;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.service.ContainerTemplate;
import io.fabric8.service.JmxTemplateSupport;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.utils.Ports;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.RetryOneTime;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.zookeeper.cluster.service", label="Fabric8 ZooKeeper Cluster Service", metatype=false)
@Service(value={ZooKeeperClusterService.class})
public final class ZooKeeperClusterServiceImpl
extends AbstractComponent
implements ZooKeeperClusterService {
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=ACLProvider.class)
    private final ValidatingReference<ACLProvider> aclProvider = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=DataStore.class)
    private final ValidatingReference<DataStore> dataStore = new ValidatingReference();
    @Reference(referenceInterface=DataStoreRegistrationHandler.class)
    private final ValidatingReference<DataStoreRegistrationHandler> registrationHandler = new ValidatingReference();
    @Reference(referenceInterface=ZooKeeperClusterBootstrap.class)
    private final ValidatingReference<ZooKeeperClusterBootstrap> bootstrap = new ValidatingReference();
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperClusterServiceImpl.class);

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public List<String> getEnsembleContainers() {
        this.assertValid();
        try {
            Configuration[] configs = ((ConfigurationAdmin)this.configAdmin.get()).listConfigurations("(service.pid=io.fabric8.zookeeper)");
            if (configs == null || configs.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0])) != null) {
                String clusterId = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
                String containers = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{clusterId}));
                Collections.addAll(list, containers.split(","));
            }
            return list;
        }
        catch (Exception e) {
            throw new FabricException("Unable to load zookeeper quorum containers", (Throwable)e);
        }
    }

    public String getZooKeeperUrl() {
        this.assertValid();
        return ((FabricService)this.fabricService.get()).getZookeeperUrl();
    }

    public String getZookeeperPassword() {
        this.assertValid();
        return ((FabricService)this.fabricService.get()).getZookeeperPassword();
    }

    public Map<String, String> getEnsembleConfiguration() throws Exception {
        String clusterId = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
        String version = ((DataStore)this.dataStore.get()).getDefaultVersion();
        String profileId = "fabric-ensemble-" + clusterId;
        String ensembleConfigName = "io.fabric8.zookeeper.server-" + clusterId + ".properties";
        return DataStoreUtils.toMap((byte[])((DataStore)this.dataStore.get()).getFileConfigurations(version, profileId).get(ensembleConfigName));
    }

    public void createCluster(List<String> containers) {
        this.assertValid();
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        this.createCluster(containers, CreateEnsembleOptions.builder().fromRuntimeProperties(sysprops).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createCluster(List<String> containers, CreateEnsembleOptions options) {
        this.assertValid();
        List<String> oldContainers = this.getEnsembleContainers();
        try {
            if (containers == null || containers.size() == 2) {
                throw new EnsembleModificationFailed("One or at least 3 containers must be used to create a zookeeper ensemble", EnsembleModificationFailed.Reason.INVALID_ARGUMENTS);
            }
            Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.zookeeper", null);
            String zooKeeperUrl = config != null && config.getProperties() != null ? (String)config.getProperties().get("zookeeper.url") : null;
            String karafName = ((RuntimeProperties)this.runtimeProperties.get()).getProperty("karaf.name");
            if (zooKeeperUrl == null) {
                if (containers.size() != 1 || !containers.get(0).equals(karafName)) {
                    throw new EnsembleModificationFailed("The first zookeeper cluster must be configured on this container only.", EnsembleModificationFailed.Reason.INVALID_ARGUMENTS);
                }
                ((ZooKeeperClusterBootstrap)this.bootstrap.get()).create(options);
                return;
            }
            Container[] allContainers = ((FabricService)this.fabricService.get()).getContainers();
            HashSet<Container> notAliveOrOk = new HashSet<Container>();
            for (Container container : allContainers) {
                if (container.isAliveAndOK()) continue;
                notAliveOrOk.add(container);
            }
            if (!notAliveOrOk.isEmpty()) {
                throw new EnsembleModificationFailed("Can not modify the zookeeper ensemble if all containers are not running. Containers not ready:" + notAliveOrOk, EnsembleModificationFailed.Reason.CONTAINERS_NOT_ALIVE);
            }
            String version = ((DataStore)this.dataStore.get()).getDefaultVersion();
            for (String container : containers) {
                Container c = ((FabricService)this.fabricService.get()).getContainer(container);
                if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{container})) != null) continue;
                throw new EnsembleModificationFailed("The container " + container + " is not alive", EnsembleModificationFailed.Reason.CONTAINERS_NOT_ALIVE);
            }
            HashMap<String, List<Integer>> usedPorts = new HashMap<String, List<Integer>>();
            String oldClusterId = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]));
            if (oldClusterId != null) {
                String profile = "fabric-ensemble-" + oldClusterId;
                String pid = "io.fabric8.zookeeper.server-" + oldClusterId;
                Map p = ((DataStore)this.dataStore.get()).getConfiguration(version, profile, pid);
                if (p == null) {
                    throw new EnsembleModificationFailed("Failed to find old cluster configuration for ID " + oldClusterId, EnsembleModificationFailed.Reason.ILLEGAL_STATE);
                }
                for (Object n : p.keySet()) {
                    String node = (String)n;
                    if (!node.startsWith("server.")) continue;
                    String data = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)((String)((Map)((DataStore)this.dataStore.get()).getConfigurations(version, "fabric-ensemble-" + oldClusterId).get("io.fabric8.zookeeper.server-" + oldClusterId)).get(node)));
                    this.addUsedPorts(usedPorts, data);
                }
                Map zkConfig = ((DataStore)this.dataStore.get()).getConfiguration(version, "default", "io.fabric8.zookeeper");
                if (zkConfig == null) {
                    throw new FabricException("Failed to find old zookeeper configuration in default profile");
                }
                String zkUrl = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)((String)zkConfig.get("zookeeper.url")));
                for (String data : zkUrl.split(",")) {
                    this.addUsedPorts(usedPorts, data);
                }
            }
            String newClusterId = oldClusterId == null ? "0000" : new DecimalFormat("0000").format(Integer.parseInt(oldClusterId) + 1);
            String ensembleProfile = ((DataStore)this.dataStore.get()).getProfile(version, "fabric-ensemble-" + newClusterId, true);
            ((DataStore)this.dataStore.get()).setProfileAttribute(version, ensembleProfile, "abstract", "true");
            ((DataStore)this.dataStore.get()).setProfileAttribute(version, ensembleProfile, "hidden", "true");
            Properties ensembleProperties = new Properties();
            ensembleProperties.put("tickTime", String.valueOf(options.getZooKeeperServerTickTime()));
            ensembleProperties.put("initLimit", String.valueOf(options.getZooKeeperServerInitLimit()));
            ensembleProperties.put("syncLimit", String.valueOf(options.getZooKeeperServerSyncLimit()));
            ensembleProperties.put("dataDir", options.getZooKeeperServerDataDir() + File.separator + newClusterId);
            int index = 1;
            String connectionUrl = "";
            String realConnectionUrl = "";
            String containerList = "";
            for (String container : containers) {
                String ip = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_IP.getPath(new String[]{container}));
                String minimumPort = String.valueOf(0);
                String maximumPort = String.valueOf(65535);
                String bindAddress = "0.0.0.0";
                if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{container})) != null) {
                    minimumPort = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{container}));
                }
                if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{container})) != null) {
                    maximumPort = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{container}));
                }
                if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_BINDADDRESS.getPath(new String[]{container})) != null) {
                    bindAddress = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_BINDADDRESS.getPath(new String[]{container}));
                }
                String ensembleMemberConfigName = "io.fabric8.zookeeper.server-" + newClusterId + ".properties";
                Properties ensembleMemberProperties = new Properties();
                String ensembleMemberProfile = ((DataStore)this.dataStore.get()).getProfile(version, "fabric-ensemble-" + newClusterId + "-" + Integer.toString(index), true);
                ((DataStore)this.dataStore.get()).setProfileAttribute(version, ensembleMemberProfile, "hidden", "true");
                ((DataStore)this.dataStore.get()).setProfileAttribute(version, ensembleMemberProfile, "parents", ensembleProfile);
                String port1 = this.publicPort(container, Integer.toString(this.findPort(usedPorts, ip, Ports.mapPortToRange(2181, minimumPort, maximumPort))));
                if (containers.size() > 1) {
                    String port2 = this.publicPort(container, Integer.toString(this.findPort(usedPorts, ip, Ports.mapPortToRange(2888, minimumPort, maximumPort))));
                    String port3 = this.publicPort(container, Integer.toString(this.findPort(usedPorts, ip, Ports.mapPortToRange(3888, minimumPort, maximumPort))));
                    ensembleProperties.put("server." + Integer.toString(index), "${zk:" + container + "/ip}:" + port2 + ":" + port3);
                    ensembleMemberProperties.put("server.id", Integer.toString(index));
                }
                ensembleMemberProperties.put("clientPort", port1);
                ensembleMemberProperties.put("clientPortAddress", bindAddress);
                ((DataStore)this.dataStore.get()).setFileConfiguration(version, ensembleMemberProfile, ensembleMemberConfigName, DataStoreUtils.toBytes(ensembleMemberProperties));
                if (connectionUrl.length() > 0) {
                    connectionUrl = connectionUrl + ",";
                    realConnectionUrl = realConnectionUrl + ",";
                }
                connectionUrl = connectionUrl + "${zk:" + container + "/ip}:" + port1;
                realConnectionUrl = realConnectionUrl + ip + ":" + port1;
                if (containerList.length() > 0) {
                    containerList = containerList + ",";
                }
                containerList = containerList + container;
                ++index;
            }
            String ensembleConfigName = "io.fabric8.zookeeper.server-" + newClusterId + ".properties";
            ((DataStore)this.dataStore.get()).setFileConfiguration(version, ensembleProfile, ensembleConfigName, DataStoreUtils.toBytes(ensembleProperties));
            index = 1;
            for (String container : containers) {
                LinkedList<String> profiles = new LinkedList<String>(((DataStore)this.dataStore.get()).getContainerProfiles(container));
                profiles.add("fabric-ensemble-" + newClusterId + "-" + Integer.toString(index));
                ((DataStore)this.dataStore.get()).setContainerProfiles(container, profiles);
                ++index;
            }
            if (oldClusterId != null) {
                Properties properties = DataStoreUtils.toProperties(((DataStore)this.dataStore.get()).getConfiguration(version, "default", "io.fabric8.zookeeper"));
                properties.put("zookeeper.url", ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)realConnectionUrl));
                properties.put("zookeeper.password", options.getZookeeperPassword());
                CuratorFramework dst = CuratorFrameworkFactory.builder().connectString(realConnectionUrl).retryPolicy((RetryPolicy)new RetryOneTime(500)).aclProvider((ACLProvider)this.aclProvider.get()).authorization("digest", ("fabric:" + options.getZookeeperPassword()).getBytes()).sessionTimeoutMs(30000).connectionTimeoutMs((int)options.getMigrationTimeout()).build();
                dst.start();
                try {
                    long t0 = System.currentTimeMillis();
                    if (!dst.getZookeeperClient().blockUntilConnectedOrTimedOut()) {
                        throw new EnsembleModificationFailed("Timed out connecting to new ensemble.", EnsembleModificationFailed.Reason.TIMEOUT);
                    }
                    ZooKeeperUtils.copy((CuratorFramework)((CuratorFramework)this.curator.get()), (CuratorFramework)dst, (String)"/fabric");
                    ZooKeeperUtils.setData((CuratorFramework)dst, (String)ZkPath.CONFIG_ENSEMBLES.getPath(new String[0]), (String)newClusterId);
                    ZooKeeperUtils.setData((CuratorFramework)dst, (String)ZkPath.CONFIG_ENSEMBLE.getPath(new String[]{newClusterId}), (String)containerList);
                    Container[] result = new AtomicReference();
                    ((DataStoreRegistrationHandler)this.registrationHandler.get()).setRegistrationCallback(new DataStoreTemplate((AtomicReference)result){
                        final /* synthetic */ AtomicReference val$result;
                        {
                            this.val$result = atomicReference;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void doWith(DataStore dataStore) {
                            AtomicReference atomicReference = this.val$result;
                            synchronized (atomicReference) {
                                this.val$result.set(dataStore);
                                this.val$result.notifyAll();
                            }
                        }
                    });
                    ZooKeeperUtils.setData((CuratorFramework)dst, (String)ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]), (String)PasswordEncoder.encode(options.getZookeeperPassword()));
                    ZooKeeperUtils.setData((CuratorFramework)dst, (String)ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]), (String)connectionUrl);
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]), (String)PasswordEncoder.encode(options.getZookeeperPassword()));
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]), (String)connectionUrl);
                    boolean allStarted = false;
                    while (!allStarted && System.currentTimeMillis() - t0 < options.getMigrationTimeout()) {
                        allStarted = true;
                        for (Container container : allContainers) {
                            allStarted &= ZooKeeperUtils.exists((CuratorFramework)dst, (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{container.getId()})) != null;
                        }
                        if (allStarted) continue;
                        Thread.sleep(1000L);
                    }
                    if (!allStarted) {
                        throw new EnsembleModificationFailed("Timeout waiting for containers to join the new ensemble", EnsembleModificationFailed.Reason.TIMEOUT);
                    }
                    Container[] arr$ = result;
                    synchronized (result) {
                        if (result.get() == null) {
                            result.wait();
                        }
                        // ** MonitorExit[arr$] (shouldn't be in output)
                        for (String container : oldContainers) {
                            this.cleanUpEnsembleProfiles((DataStore)result.get(), container, oldClusterId);
                        }
                        return;
                    }
                }
                finally {
                    dst.close();
                }
            }
            Map zkConfig = ((DataStore)this.dataStore.get()).getConfiguration(version, "default", "io.fabric8.zookeeper");
            zkConfig.put("zookeeper.password", "${zk:" + ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0]) + "}");
            zkConfig.put("zookeeper.url", "${zk:" + ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0]) + "}");
            ((DataStore)this.dataStore.get()).setConfiguration(version, "default", "io.fabric8.zookeeper", zkConfig);
            return;
        }
        catch (Exception e) {
            throw EnsembleModificationFailed.launderThrowable((Throwable)e);
        }
    }

    private String publicPort(String containerName, final String port) {
        FabricService fabric = (FabricService)this.fabricService.get();
        Container container = fabric.getContainer(containerName);
        String user = ZooKeeperUtils.getContainerLogin((RuntimeProperties)((RuntimeProperties)this.runtimeProperties.get()));
        String password = "";
        try {
            Properties containerTokens = ZooKeeperUtils.getContainerTokens((CuratorFramework)((CuratorFramework)this.curator.get()));
            password = containerTokens.getProperty(user);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get temp ZK user/pass for administrative purposes", (Throwable)e);
        }
        ContainerTemplate containerTemplate = new ContainerTemplate(container, user, password, false);
        return containerTemplate.execute(new JmxTemplateSupport.JmxConnectorCallback<String>(){

            @Override
            public String doWithJmxConnector(JMXConnector connector) throws Exception {
                return connector.getMBeanServerConnection().invoke(new ObjectName("io.fabric8:type=Fabric"), "getPublicPortOnCurrentContainer", new Object[]{new Integer(port)}, new String[]{"int"}).toString();
            }
        });
    }

    public void addToCluster(List<String> containers) {
        this.assertValid();
        CreateEnsembleOptions options = CreateEnsembleOptions.builder().zookeeperPassword(((FabricService)this.fabricService.get()).getZookeeperPassword()).build();
        this.addToCluster(containers, options);
    }

    public void addToCluster(List<String> containers, CreateEnsembleOptions options) {
        this.assertValid();
        try {
            List<String> current = this.getEnsembleContainers();
            for (String c : containers) {
                if (current.contains(c)) {
                    throw new EnsembleModificationFailed("Container " + c + " is already part of the ensemble.", EnsembleModificationFailed.Reason.CONTAINERS_ALREADY_IN_ENSEMBLE);
                }
                current.add(c);
            }
            this.createCluster(current, options);
        }
        catch (Exception e) {
            throw EnsembleModificationFailed.launderThrowable((Throwable)e);
        }
    }

    public void removeFromCluster(List<String> containers) {
        this.assertValid();
        CreateEnsembleOptions.Builder builder = CreateEnsembleOptions.builder();
        String password = ((FabricService)this.fabricService.get()).getZookeeperPassword();
        CreateEnsembleOptions options = builder.zookeeperPassword(password).build();
        this.removeFromCluster(containers, options);
    }

    public void removeFromCluster(List<String> containers, CreateEnsembleOptions options) {
        this.assertValid();
        try {
            List<String> current = this.getEnsembleContainers();
            for (String c : containers) {
                if (!current.contains(c)) {
                    throw new EnsembleModificationFailed("Container " + c + " is not part of the ensemble.", EnsembleModificationFailed.Reason.CONTAINERS_NOT_IN_ENSEMBLE);
                }
                current.remove(c);
            }
            this.createCluster(current, options);
        }
        catch (Exception e) {
            throw EnsembleModificationFailed.launderThrowable((Throwable)e);
        }
    }

    private void cleanUpEnsembleProfiles(DataStore dataStore, String container, String clusterId) {
        LinkedList profiles = new LinkedList(dataStore.getContainerProfiles(container));
        LinkedList<String> toRemove = new LinkedList<String>();
        for (String p : profiles) {
            if (!p.startsWith("fabric-ensemble-" + clusterId)) continue;
            toRemove.add(p);
        }
        profiles.removeAll(toRemove);
        dataStore.setContainerProfiles(container, profiles);
    }

    private int findPort(Map<String, List<Integer>> usedPorts, String ip, int port) {
        List<Integer> ports = usedPorts.get(ip);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(ip, ports);
        }
        while (true) {
            if (!ports.contains(port)) {
                ports.add(port);
                return port;
            }
            ++port;
        }
    }

    private void addUsedPorts(Map<String, List<Integer>> usedPorts, String data) {
        String[] parts = data.split(":");
        List<Integer> ports = usedPorts.get(parts[0]);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            usedPorts.put(parts[0], ports);
        }
        for (int i = 1; i < parts.length; ++i) {
            ports.add(Integer.parseInt(parts[i]));
        }
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindBootstrap(ZooKeeperClusterBootstrap bootstrap) {
        this.bootstrap.bind((Object)bootstrap);
    }

    void unbindBootstrap(ZooKeeperClusterBootstrap bootstrap) {
        this.bootstrap.unbind((Object)bootstrap);
    }

    void bindAclProvider(ACLProvider aclProvider) {
        this.aclProvider.bind((Object)aclProvider);
    }

    void unbindAclProvider(ACLProvider aclProvider) {
        this.aclProvider.unbind((Object)aclProvider);
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.bind((Object)service);
    }

    void unbindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.unbind((Object)service);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindDataStore(DataStore dataStore) {
        this.dataStore.bind((Object)dataStore);
    }

    void unbindDataStore(DataStore dataStore) {
        this.dataStore.unbind((Object)dataStore);
    }
}

