/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ops4j.pax.web.extender.war.internal.DefaultWebAppDependencyHolder;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.tracker.ReplaceableService;
import org.ops4j.pax.web.extender.war.internal.tracker.ReplaceableServiceListener;
import org.ops4j.pax.web.service.WebAppDependencyHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class DefaultWebAppDependencyManager {
    private ConcurrentMap<WebApp, ReplaceableService<HttpService>> trackers = new ConcurrentHashMap<WebApp, ReplaceableService<HttpService>>();

    public void addWebApp(final WebApp webApp) {
        final BundleContext webAppContext = webApp.getBundle().getBundleContext();
        ReplaceableService<HttpService> tracker = new ReplaceableService<HttpService>(webAppContext, HttpService.class, new ReplaceableServiceListener<HttpService>(){
            private ServiceRegistration<WebAppDependencyHolder> registration;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serviceChanged(HttpService oldService, HttpService newService) {
                ServiceRegistration<WebAppDependencyHolder> oldReg;
                ServiceRegistration newReg;
                if (newService != null) {
                    DefaultWebAppDependencyHolder holder = new DefaultWebAppDependencyHolder(newService);
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("bundle.id", Long.toString(webApp.getBundle().getBundleId()));
                    newReg = webAppContext.registerService(WebAppDependencyHolder.class, (Object)holder, props);
                } else {
                    newReg = null;
                }
                1 var5_3 = this;
                synchronized (var5_3) {
                    oldReg = this.registration;
                    this.registration = newReg;
                }
                if (oldReg != null) {
                    oldReg.unregister();
                }
            }
        });
        if (this.trackers.putIfAbsent(webApp, tracker) == null) {
            tracker.start();
        }
    }

    public void removeWebApp(WebApp webApp) {
        ReplaceableService tracker = (ReplaceableService)this.trackers.remove(webApp);
        if (tracker != null) {
            tracker.stop();
        }
    }
}

