/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.commands.ContainerLifecycleCommand;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="container-delete", scope="fabric", description="Stops and deletes an existing container", detailedDescription="classpath:containerDelete.txt")
public class ContainerDelete
extends ContainerLifecycleCommand {
    @Option(name="-r", aliases={"--recursive"}, multiValued=false, required=false, description="Recursively stops and deletes all child containers")
    protected boolean recursive = false;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.container);
        if (this.isPartOfEnsemble(this.container) && !this.force) {
            System.out.println("Container is part of the ensemble. If you still want to delete it, please use -f option.");
            return null;
        }
        String runtimeIdentity = this.fabricService.getCurrentContainerName();
        if (this.container.equals(runtimeIdentity) && !this.force) {
            System.out.println("You shouldn't delete current container. If you still want to delete it, please use --force option.");
            return null;
        }
        Container found = this.getContainer(this.container);
        this.applyUpdatedCredentials(found);
        if (this.recursive || this.force) {
            for (Container child : found.getChildren()) {
                child.destroy(this.force);
            }
        }
        found.destroy(this.force);
        return null;
    }
}

