/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.GetDataFromTreeOperation;
import org.apache.curator.framework.recipes.cache.Operation;
import org.apache.curator.framework.recipes.cache.OperationComparator;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheMode;
import org.apache.curator.framework.recipes.cache.TreeData;
import org.apache.curator.framework.recipes.cache.TreeEventOperation;
import org.apache.curator.framework.recipes.cache.TreeRefreshOperation;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeCache
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String path;
    private final ExecutorService executorService;
    private final boolean cacheData;
    private final boolean diffData;
    private final boolean dataIsCompressed;
    private final EnsurePath ensurePath;
    private final BlockingQueue<Operation> operations = new PriorityBlockingQueue<Operation>(10, new OperationComparator());
    private final ListenerContainer<PathChildrenCacheListener> listeners = new ListenerContainer();
    private final LoadingCache<String, TreeData> currentData = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, TreeData>(){

        public TreeData load(String key) throws Exception {
            Stat stat = (Stat)TreeCache.this.client.checkExists().forPath(key);
            if (stat != null) {
                byte[] bytes = TreeCache.this.dataIsCompressed ? (byte[])((BackgroundPathable)((GetDataWatchBackgroundStatable)TreeCache.this.client.getData().decompressed()).usingWatcher(TreeCache.this.watcher)).forPath(key) : (byte[])((BackgroundPathable)TreeCache.this.client.getData().usingWatcher(TreeCache.this.watcher)).forPath(key);
                List children = (List)((BackgroundPathable)TreeCache.this.client.getChildren().usingWatcher(TreeCache.this.watcher)).forPath(key);
                return new TreeData(key, stat, bytes, children);
            }
            return null;
        }
    });
    private final AtomicReference<Map<String, ChildData>> initialSet = new AtomicReference();
    private static final ChildData NULL_CHILD_DATA = new ChildData(null, null, null);
    private static final String CHILD_OF_ZNODE_PATTERN = "%s/[^ /]*";
    private final Watcher watcher = new Watcher(){

        @Override
        public void process(WatchedEvent event) {
            try {
                switch (event.getType()) {
                    case None: {
                        break;
                    }
                    case NodeCreated: {
                        break;
                    }
                    case NodeDeleted: {
                        TreeCache.this.remove(event.getPath());
                        break;
                    }
                    case NodeDataChanged: {
                        TreeData data = (TreeData)TreeCache.this.currentData.getIfPresent((Object)event.getPath());
                        if (data != null) {
                            data.invalidate();
                        }
                        TreeCache.this.offerOperation(new GetDataFromTreeOperation(TreeCache.this, event.getPath()));
                        break;
                    }
                    case NodeChildrenChanged: {
                        TreeData data = (TreeData)TreeCache.this.currentData.getIfPresent((Object)event.getPath());
                        if (data != null) {
                            data.invalidate();
                        }
                        TreeCache.this.offerOperation(new TreeRefreshOperation(TreeCache.this, event.getPath(), RefreshMode.FORCE_GET_DATA_AND_STAT));
                    }
                }
            }
            catch (Exception e) {
                TreeCache.this.handleException(e);
            }
        }
    };
    @VisibleForTesting
    volatile Exchanger<Object> rebuildTestExchanger;
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            TreeCache.this.handleStateChange(newState);
        }
    };
    private static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory("PathChildrenCache");

    public TreeCache(CuratorFramework client, String path, PathChildrenCacheMode mode) {
        this(client, path, mode != PathChildrenCacheMode.CACHE_PATHS_ONLY, false, Executors.newSingleThreadExecutor(defaultThreadFactory));
    }

    public TreeCache(CuratorFramework client, String path, boolean cacheData) {
        this(client, path, cacheData, false, Executors.newSingleThreadExecutor(defaultThreadFactory));
    }

    public TreeCache(CuratorFramework client, String path, boolean cacheData, boolean diffData) {
        this(client, path, cacheData, false, diffData, Executors.newSingleThreadExecutor(defaultThreadFactory));
    }

    public TreeCache(CuratorFramework client, String path, boolean cacheData, ThreadFactory threadFactory) {
        this(client, path, cacheData, false, Executors.newSingleThreadExecutor(threadFactory));
    }

    public TreeCache(CuratorFramework client, String path, boolean cacheData, boolean dataIsCompressed, ThreadFactory threadFactory) {
        this(client, path, cacheData, dataIsCompressed, Executors.newSingleThreadExecutor(threadFactory));
    }

    public TreeCache(CuratorFramework client, String path, boolean cacheData, boolean dataIsCompressed, ExecutorService executorService) {
        this(client, path, cacheData, dataIsCompressed, false, executorService);
    }

    public TreeCache(CuratorFramework client, String path, boolean cacheData, boolean dataIsCompressed, boolean diffData, ExecutorService executorService) {
        this.client = client;
        this.path = path;
        this.cacheData = cacheData;
        this.diffData = diffData;
        this.dataIsCompressed = dataIsCompressed;
        this.executorService = executorService;
        this.ensurePath = client.newNamespaceAwareEnsurePath(path);
    }

    public void start() throws Exception {
        this.start(StartMode.NORMAL);
    }

    public void start(boolean buildInitial) throws Exception {
        this.start(buildInitial ? StartMode.BUILD_INITIAL_CACHE : StartMode.NORMAL);
    }

    public void start(StartMode mode) throws Exception {
        Preconditions.checkState((!this.executorService.isShutdown() ? 1 : 0) != 0, (Object)"already started");
        mode = (StartMode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode cannot be null"));
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                TreeCache.this.mainLoop();
            }
        });
        switch (mode) {
            case NORMAL: {
                this.offerOperation(new TreeRefreshOperation(this, this.path, RefreshMode.STANDARD));
                break;
            }
            case BUILD_INITIAL_CACHE: {
                this.rebuild();
                break;
            }
            case POST_INITIALIZED_EVENT: {
                this.initialSet.set(Maps.newConcurrentMap());
                this.offerOperation(new TreeRefreshOperation(this, this.path, RefreshMode.POST_INITIALIZED));
            }
        }
    }

    public void rebuild() throws Exception {
        Preconditions.checkState((!this.executorService.isShutdown() ? 1 : 0) != 0, (Object)"cache has been closed");
        this.ensurePath.ensure(this.client.getZookeeperClient());
        this.clear();
        List children = (List)this.client.getChildren().forPath(this.path);
        for (String child : children) {
            String fullPath = ZKPaths.makePath(this.path, child);
            this.internalRebuildNode(fullPath);
            if (this.rebuildTestExchanger == null) continue;
            this.rebuildTestExchanger.exchange(new Object());
        }
        this.offerOperation(new TreeRefreshOperation(this, this.path, RefreshMode.FORCE_GET_DATA_AND_STAT));
    }

    public void rebuildNode(String fullPath) throws Exception {
        Preconditions.checkArgument((boolean)ZKPaths.getPathAndNode(fullPath).getPath().startsWith(this.path), (Object)("Node is not part of this cache: " + fullPath));
        Preconditions.checkState((!this.executorService.isShutdown() ? 1 : 0) != 0, (Object)"cache has been closed");
        this.ensurePath.ensure(this.client.getZookeeperClient());
        this.internalRebuildNode(fullPath);
        this.offerOperation(new TreeRefreshOperation(this, this.path, RefreshMode.FORCE_GET_DATA_AND_STAT));
    }

    @Override
    public void close() throws IOException {
        this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
        this.executorService.shutdownNow();
    }

    public ListenerContainer<PathChildrenCacheListener> getListenable() {
        return this.listeners;
    }

    public List<TreeData> getCurrentData() {
        return ImmutableList.copyOf((Collection)Sets.newTreeSet(this.currentData.asMap().values()));
    }

    public TreeData getCurrentData(String fullPath) {
        try {
            TreeData data;
            while ((data = (TreeData)this.currentData.get((Object)fullPath)).isInvalidated()) {
                this.currentData.invalidate((Object)fullPath);
            }
            return data;
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }

    public List<TreeData> getChildren(String fullPath) {
        ArrayList children = Lists.newArrayList();
        for (String child : this.getChildrenNames(fullPath)) {
            String childFullPath = ZKPaths.makePath(fullPath, child);
            children.add(this.getCurrentData(childFullPath));
        }
        return children;
    }

    public List<String> getChildrenNames(String fullPath) {
        TreeData parentData = this.getCurrentData(fullPath);
        if (parentData != null) {
            return new ArrayList<String>(parentData.getChildren());
        }
        return Lists.newArrayList();
    }

    public void clearDataBytes(String fullPath) {
        this.clearDataBytes(fullPath, -1);
    }

    public boolean clearDataBytes(String fullPath, int ifVersion) {
        TreeData data = (TreeData)this.currentData.getIfPresent((Object)fullPath);
        if (data != null && (ifVersion < 0 || ifVersion == data.getStat().getVersion())) {
            data.clearData();
            return true;
        }
        return false;
    }

    public void clearAndRefresh() throws Exception {
        this.currentData.invalidateAll();
        this.offerOperation(new TreeRefreshOperation(this, this.path, RefreshMode.STANDARD));
    }

    public void clear() {
        this.currentData.invalidateAll();
    }

    void refresh(String path, RefreshMode mode) throws Exception {
        this.ensurePath.ensure(this.client.getZookeeperClient());
        Stat stat = new Stat();
        List children = (List)((Pathable)((WatchPathable)this.client.getChildren().storingStatIn(stat)).usingWatcher(this.watcher)).forPath(path);
        this.processChildren(path, children, mode);
        this.updateIfNeeded(path, stat, children);
    }

    void callListeners(final PathChildrenCacheEvent event) {
        this.listeners.forEach(new Function<PathChildrenCacheListener, Void>(){

            public Void apply(PathChildrenCacheListener listener) {
                try {
                    listener.childEvent(TreeCache.this.client, event);
                }
                catch (Exception e) {
                    TreeCache.this.handleException(e);
                }
                return null;
            }
        });
    }

    void getDataAndStat(String fullPath) throws Exception {
        if (this.client.checkExists().forPath(fullPath) == null) {
            return;
        }
        List children = (List)((BackgroundPathable)this.client.getChildren().usingWatcher(this.watcher)).forPath(fullPath);
        if (this.cacheData) {
            Stat stat = new Stat();
            byte[] data = null;
            data = this.dataIsCompressed ? (byte[])((Pathable)((WatchPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).storingStatIn(stat)).usingWatcher(this.watcher)).forPath(fullPath) : (byte[])((Pathable)((WatchPathable)this.client.getData().storingStatIn(stat)).usingWatcher(this.watcher)).forPath(fullPath);
            this.applyNewData(fullPath, KeeperException.Code.OK.intValue(), stat, data, children);
        } else {
            Stat stat = (Stat)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).forPath(fullPath);
            this.applyNewData(fullPath, KeeperException.Code.OK.intValue(), stat, null, children);
        }
    }

    protected void handleException(Throwable e) {
        this.log.error("", e);
    }

    @VisibleForTesting
    protected void remove(String fullPath) {
        Map<String, ChildData> localInitialSet;
        TreeData data = (TreeData)this.currentData.getIfPresent((Object)fullPath);
        if (data != null) {
            this.currentData.invalidate((Object)fullPath);
            this.offerOperation(new TreeEventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CHILD_REMOVED, data)));
        }
        if ((localInitialSet = this.initialSet.get()) != null) {
            localInitialSet.remove(fullPath);
            this.maybeOfferInitializedEvent(localInitialSet);
        }
        this.removeFromParent(fullPath);
    }

    private void internalRebuildNode(String fullPath) throws Exception {
        if (this.cacheData) {
            try {
                Stat stat = new Stat();
                byte[] bytes = this.dataIsCompressed ? (byte[])((WatchPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).storingStatIn(stat)).forPath(fullPath) : (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(fullPath);
                List children = (List)this.client.getChildren().forPath(fullPath);
                this.currentData.put((Object)fullPath, (Object)new TreeData(fullPath, stat, bytes, children));
                for (String child : children) {
                    String childPath = ZKPaths.makePath(fullPath, child);
                    this.internalRebuildNode(childPath);
                }
            }
            catch (KeeperException.NoNodeException ignore) {
                this.currentData.invalidate((Object)fullPath);
                this.removeFromParent(fullPath);
            }
        } else {
            Stat stat = (Stat)this.client.checkExists().forPath(fullPath);
            if (stat != null) {
                List children = (List)this.client.getChildren().forPath(fullPath);
                this.currentData.put((Object)fullPath, (Object)new TreeData(fullPath, stat, null, children));
                for (String child : children) {
                    String childPath = ZKPaths.makePath(fullPath, child);
                    this.internalRebuildNode(childPath);
                }
            } else {
                this.currentData.invalidate((Object)fullPath);
                this.removeFromParent(fullPath);
            }
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case SUSPENDED: {
                this.offerOperation(new TreeEventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CONNECTION_SUSPENDED, null)));
                break;
            }
            case LOST: {
                this.offerOperation(new TreeEventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CONNECTION_LOST, null)));
                break;
            }
            case RECONNECTED: {
                try {
                    this.offerOperation(new TreeRefreshOperation(this, this.path, RefreshMode.FORCE_GET_DATA_AND_STAT));
                    this.offerOperation(new TreeEventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CONNECTION_RECONNECTED, null)));
                    break;
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }

    private void processChildren(final String path, List<String> children, RefreshMode mode) throws Exception {
        ArrayList fullPaths = Lists.newArrayList((Iterable)Lists.transform(children, (Function)new Function<String, String>(){

            public String apply(String child) {
                return ZKPaths.makePath(path, child);
            }
        }));
        Set removedNodes = Sets.filter((Set)Sets.newHashSet(this.currentData.asMap().keySet()), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.matches(String.format(TreeCache.CHILD_OF_ZNODE_PATTERN, path));
            }
        });
        removedNodes.removeAll(fullPaths);
        for (String fullPath : removedNodes) {
            this.remove(fullPath);
        }
        for (String name : children) {
            String fullPath = ZKPaths.makePath(path, name);
            if (mode == RefreshMode.FORCE_GET_DATA_AND_STAT || this.currentData.getIfPresent((Object)fullPath) == null) {
                this.getDataAndStat(fullPath);
            }
            this.updateInitialSet(fullPath, NULL_CHILD_DATA);
            this.offerOperation(new TreeRefreshOperation(this, fullPath, mode));
        }
        this.maybeOfferInitializedEvent(this.initialSet.get());
    }

    private void updateIfNeeded(String path, Stat stat, List<String> children) throws Exception {
        TreeData data = (TreeData)this.currentData.getIfPresent((Object)path);
        if (data != null && stat != null && stat.getMzxid() > data.getStat().getMzxid()) {
            this.applyNewData(path, KeeperException.Code.OK.intValue(), stat, data.getData(), children);
        }
    }

    private synchronized void addToParent(String fullPath) {
        TreeData parentData;
        Optional<String> parent = this.getParentOf(fullPath);
        if (parent.isPresent() && (parentData = (TreeData)this.currentData.getIfPresent(parent.get())) != null) {
            parentData.getChildren().add(ZKPaths.getNodeFromPath(fullPath));
        }
    }

    private synchronized void removeFromParent(String fullPath) {
        TreeData parentData;
        Optional<String> parent = this.getParentOf(fullPath);
        if (parent.isPresent() && (parentData = (TreeData)this.currentData.getIfPresent(parent.get())) != null) {
            parentData.getChildren().remove(ZKPaths.getNodeFromPath(fullPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNewData(String fullPath, int resultCode, Stat stat, byte[] bytes, List<String> children) {
        if (resultCode == KeeperException.Code.OK.intValue()) {
            TreeData previousData;
            TreeData data = new TreeData(fullPath, stat, bytes, children);
            TreeCache treeCache = this;
            synchronized (treeCache) {
                previousData = (TreeData)this.currentData.getIfPresent((Object)fullPath);
                this.currentData.put((Object)fullPath, (Object)data);
                this.addToParent(fullPath);
            }
            if (previousData == null) {
                this.offerOperation(new TreeEventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CHILD_ADDED, data)));
            } else if (!(previousData.getStat().getVersion() == stat.getVersion() || this.diffData && Arrays.equals(data.getData(), previousData.getData()))) {
                this.offerOperation(new TreeEventOperation(this, new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.CHILD_UPDATED, data)));
            }
            this.updateInitialSet(ZKPaths.getNodeFromPath(fullPath), data);
        }
    }

    private void updateInitialSet(String name, ChildData data) {
        Map<String, ChildData> localInitialSet = this.initialSet.get();
        if (localInitialSet != null) {
            localInitialSet.put(name, data);
            this.maybeOfferInitializedEvent(localInitialSet);
        }
    }

    private void maybeOfferInitializedEvent(Map<String, ChildData> localInitialSet) {
        if (!this.hasUninitialized(localInitialSet) && this.initialSet.getAndSet(null) != null) {
            ImmutableList children = ImmutableList.copyOf(localInitialSet.values());
            PathChildrenCacheEvent event = new PathChildrenCacheEvent(PathChildrenCacheEvent.Type.INITIALIZED, null, (List)children){
                final /* synthetic */ List val$children;
                {
                    this.val$children = list;
                    super(x0, x1);
                }

                @Override
                public List<ChildData> getInitialData() {
                    return this.val$children;
                }
            };
            this.offerOperation(new TreeEventOperation(this, event));
        }
    }

    private boolean hasUninitialized(Map<String, ChildData> localInitialSet) {
        if (localInitialSet == null) {
            return false;
        }
        Map uninitializedChildren = Maps.filterValues(localInitialSet, (Predicate)new Predicate<ChildData>(){

            public boolean apply(ChildData input) {
                return input == NULL_CHILD_DATA;
            }
        });
        return uninitializedChildren.size() != 0;
    }

    private void mainLoop() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.operations.take().invoke();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void offerOperation(Operation operation) {
        this.operations.remove(operation);
        this.operations.offer(operation);
    }

    private Optional<String> getParentOf(String path) {
        if (path == null || path.equals("/")) {
            return Optional.absent();
        }
        return Optional.of((Object)path.substring(0, path.lastIndexOf("/")));
    }

    static enum RefreshMode {
        STANDARD,
        FORCE_GET_DATA_AND_STAT,
        POST_INITIALIZED;

    }

    public static enum StartMode {
        NORMAL,
        BUILD_INITIAL_CACHE,
        POST_INITIALIZED_EVENT;

    }
}

