/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.service;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.SortedMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.fusesource.process.manager.InstallOptions;
import org.fusesource.process.manager.InstallTask;
import org.fusesource.process.manager.Installation;
import org.fusesource.process.manager.ProcessController;
import org.fusesource.process.manager.config.JsonHelper;
import org.fusesource.process.manager.config.ProcessConfig;
import org.fusesource.process.manager.service.ProcessManagerServiceMBean;
import org.fusesource.process.manager.support.DefaultProcessController;
import org.fusesource.process.manager.support.FileUtils;
import org.fusesource.process.manager.support.JarInstaller;
import org.fusesource.process.manager.support.ProcessUtils;
import org.fusesource.process.manager.support.command.CommandFailedException;
import org.fusesource.process.manager.support.command.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessManagerService
implements ProcessManagerServiceMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessManagerService.class);
    private static final String INSTALLED_BINARY = "install.bin";
    private Executor executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("fuse-process-manager-%s").build());
    private File storageLocation;
    private int lastId = 0;
    private final Duration untarTimeout = Duration.valueOf("1h");
    private SortedMap<Integer, Installation> installations = Maps.newTreeMap();
    private final ObjectName objectName;
    private MBeanServer mbeanServer;

    public ProcessManagerService() throws MalformedObjectNameException {
        this(new File(System.getProperty("karaf.processes", System.getProperty("karaf.base") + File.separatorChar + "processes")));
    }

    public ProcessManagerService(File storageLocation) throws MalformedObjectNameException {
        this.storageLocation = storageLocation;
        this.objectName = new ObjectName("io.fabric8:type=LocalProcesses");
    }

    public void bindMBeanServer(MBeanServer mbeanServer) {
        this.unbindMBeanServer(this.mbeanServer);
        this.mbeanServer = mbeanServer;
        if (mbeanServer != null) {
            this.registerMBeanServer(mbeanServer);
        }
    }

    public void unbindMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            this.unregisterMBeanServer(mbeanServer);
            this.mbeanServer = null;
        }
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            if (!mbeanServer.isRegistered(this.objectName)) {
                mbeanServer.registerMBean(this, this.objectName);
            }
        }
        catch (Exception e) {
            LOGGER.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.objectName;
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOGGER.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    public void init() throws Exception {
        this.lastId = 0;
        File[] files = this.storageLocation.listFiles();
        if (files != null) {
            for (File file : files) {
                String name;
                if (!file.isDirectory() || !(name = file.getName()).matches("\\d+")) continue;
                try {
                    Integer value = Integer.parseInt(name);
                    if (value == null) continue;
                    int id = value;
                    if (id > this.lastId) {
                        this.lastId = id;
                    }
                    ProcessConfig config = JsonHelper.loadProcessConfig(file);
                    this.createInstallation(id, ProcessUtils.findInstallDir(file), config);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        return "ProcessManager(" + this.storageLocation + ")";
    }

    public ImmutableList<Installation> listInstallations() {
        return ImmutableList.copyOf(this.installations.values());
    }

    @Override
    public ImmutableMap<Integer, Installation> listInstallationMap() {
        return ImmutableMap.copyOf(this.installations);
    }

    @Override
    public Installation install(final InstallOptions options, final InstallTask postInstall) throws Exception {
        InstallTask installTask = new InstallTask(){

            @Override
            public void install(ProcessConfig config, int id, File installDir) throws Exception {
                config.setName(options.getName());
                ProcessManagerService.this.downloadContent(options.getUrl(), installDir);
                if (options.getExtractCmd() != null) {
                    File archive = new File(installDir, ProcessManagerService.INSTALLED_BINARY);
                    FileUtils.extractArchive(archive, installDir, options.getExtractCmd(), ProcessManagerService.this.untarTimeout, ProcessManagerService.this.executor);
                }
                if (postInstall != null) {
                    postInstall.install(config, id, installDir);
                }
            }
        };
        return this.installViaScript(options.getControllerUrl(), installTask);
    }

    @Override
    public Installation installJar(final InstallOptions parameters) throws Exception {
        InstallTask installTask = new InstallTask(){

            @Override
            public void install(ProcessConfig config, int id, File installDir) throws Exception {
                config.setName(parameters.getName());
                String resourceName = "process-launcher.tar.gz";
                final InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                Preconditions.checkNotNull((Object)in, (Object)("Could not find " + resourceName + " on the file system"));
                File tmpFile = File.createTempFile("process-launcher", ".tar.gz");
                Files.copy((InputSupplier)new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return in;
                    }
                }, (File)tmpFile);
                FileUtils.extractArchive(tmpFile, installDir, "tar zxf", ProcessManagerService.this.untarTimeout, ProcessManagerService.this.executor);
                File etc = new File(installDir, "etc");
                etc.mkdirs();
                Files.write((CharSequence)"", (File)new File(etc, "config.properties"), (Charset)Charsets.UTF_8);
                Files.write((CharSequence)"", (File)new File(etc, "jvm.config"), (Charset)Charsets.UTF_8);
                JarInstaller installer = new JarInstaller(ProcessManagerService.this.executor);
                installer.unpackJarProcess(config, id, installDir, parameters);
            }
        };
        return this.installViaScript(parameters.getControllerUrl(), installTask);
    }

    public File getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(File storageLocation) {
        this.storageLocation = storageLocation;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    protected Installation installViaScript(URL controllerUrl, InstallTask installTask) throws Exception {
        int id = this.createNextId();
        File installDir = this.createInstallDir(id);
        installDir.mkdirs();
        ProcessConfig config = this.loadControllerJson(controllerUrl);
        installTask.install(config, id, installDir);
        JsonHelper.saveProcessConfig(config, installDir);
        Installation installation = this.createInstallation(id, installDir, config);
        installation.getController().install();
        return installation;
    }

    protected void downloadContent(final URL url, File installDir) throws IOException, CommandFailedException {
        File archive = new File(installDir, INSTALLED_BINARY);
        Files.copy((InputSupplier)new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                return url.openStream();
            }
        }, (File)archive);
    }

    protected ProcessConfig loadControllerJson(URL controllerJson) throws IOException {
        if (controllerJson == null) {
            return new ProcessConfig();
        }
        return JsonHelper.loadProcessConfig(controllerJson);
    }

    protected synchronized int createNextId() {
        File dir;
        do {
            ++this.lastId;
        } while ((dir = this.createInstallDir(this.lastId)).exists());
        return this.lastId;
    }

    protected File createInstallDir(int id) {
        return new File(this.storageLocation, "" + id);
    }

    protected Installation createInstallation(int id, File rootDir, ProcessConfig config) {
        File installDir = ProcessUtils.findInstallDir(rootDir);
        ProcessController controller = this.createController(id, config, rootDir, installDir);
        Installation installation = new Installation(id, installDir, controller, config);
        this.installations.put(id, installation);
        return installation;
    }

    protected ProcessController createController(int id, ProcessConfig config, File rootDir, File installDir) {
        return new DefaultProcessController(id, config, installDir);
    }
}

