/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.scr.codec;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.felix.scr.Component;
import org.apache.karaf.management.mbeans.scr.ScrServiceMBean;
import org.apache.karaf.management.mbeans.scr.codec.JmxProperty;
import org.apache.karaf.management.mbeans.scr.codec.JmxReference;

public class JmxComponent {
    public static final CompositeType COMPONENT = JmxComponent.createComponenetType();
    public static final TabularType COMPONENT_TABLE = JmxComponent.createComponentTableType();
    private final CompositeData data;

    public JmxComponent(Component component) {
        try {
            String[] itemNames = ScrServiceMBean.COMPONENT;
            Object[] itemValues = new Object[itemNames.length];
            itemValues[0] = component.getId();
            itemValues[1] = component.getName();
            itemValues[2] = JmxComponent.getState(component);
            itemValues[3] = JmxProperty.tableFrom(component.getProperties());
            itemValues[4] = JmxReference.tableFrom(component.getReferences());
            this.data = new CompositeDataSupport(COMPONENT, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form feature open data", e);
        }
    }

    public CompositeData asCompositeData() {
        return this.data;
    }

    public static TabularData tableFrom(Component ... components) {
        TabularDataSupport table = new TabularDataSupport(COMPONENT_TABLE);
        for (Component component : components) {
            table.put(new JmxComponent(component).asCompositeData());
        }
        return table;
    }

    private static CompositeType createComponenetType() {
        try {
            String description = "This type encapsulates Scr references";
            String[] itemNames = ScrServiceMBean.COMPONENT;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.LONG;
            itemTypes[1] = SimpleType.STRING;
            itemTypes[2] = SimpleType.STRING;
            itemTypes[3] = JmxProperty.PROPERTY_TABLE;
            itemTypes[4] = JmxReference.REFERENCE_TABLE;
            itemDescriptions[0] = "The id of the component";
            itemDescriptions[1] = "The name of the component";
            itemDescriptions[2] = "The state of the component";
            itemDescriptions[3] = "The properties of the component";
            itemDescriptions[4] = "The references of the component";
            return new CompositeType("Component", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build component type", e);
        }
    }

    private static TabularType createComponentTableType() {
        try {
            return new TabularType("Component", "The table of all components", COMPONENT, ScrServiceMBean.COMPONENT);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build components table type", e);
        }
    }

    private static String getState(Component component) {
        switch (component.getState()) {
            case 16: {
                return "Active";
            }
            case 8: {
                return "Activating";
            }
            case 128: {
                return "Deactivating";
            }
            case 1: {
                return "Disabled";
            }
            case 1024: {
                return "Disabling";
            }
            case 256: {
                return "Disposed";
            }
            case 2048: {
                return "Disposing";
            }
            case 512: {
                return "Enabling";
            }
            case 64: {
                return "Factory";
            }
            case 32: {
                return "Registered";
            }
            case 4: {
                return "Unsatisfied";
            }
        }
        return "Unknown";
    }
}

