/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.scr.action;

import java.util.Arrays;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.shell.scr.ScrUtils;
import org.apache.karaf.shell.scr.action.ScrActionSupport;
import org.apache.karaf.shell.scr.support.IdComparator;

@Command(scope="scr", name="list", description="Displays a list of available components")
public class ListAction
extends ScrActionSupport {
    private final IdComparator idComparator = new IdComparator();

    protected Object doScrAction(ScrService scrService) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing the List Action");
        }
        System.out.println(this.getBoldString("   ID   State             Component Name"));
        Component[] components = scrService.getComponents();
        Arrays.sort(components, this.idComparator);
        for (Component component : ScrUtils.emptyIfNull(Component.class, components)) {
            if (this.showHidden) {
                this.printComponent(component);
                continue;
            }
            if (ScrActionSupport.isHiddenComponent(component)) continue;
            this.printComponent(component);
        }
        return null;
    }

    private void printComponent(Component component) {
        String name = component.getName();
        String id = this.buildLeftPadBracketDisplay(component.getId() + "", 4);
        String state = this.buildRightPadBracketDisplay(ScrUtils.getState(component.getState()), 16);
        System.out.println("[" + id + "] [" + state + "] " + name);
    }
}

