/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.ops4j.pax.web.service.jetty.internal.ConfigureRequestLogParameter;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.ResourceServlet;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerEvent;
import org.ops4j.pax.web.service.spi.ServerListener;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerControllerImpl
implements ServerController {
    private static final Logger LOG = LoggerFactory.getLogger(ServerControllerImpl.class);
    private Configuration configuration;
    private State state;
    private final JettyFactory jettyFactory;
    private JettyServer jettyServer;
    private final Set<ServerListener> listeners;
    private Connector httpConnector;
    private Connector httpSecureConnector;

    ServerControllerImpl(JettyFactory jettyFactory) {
        this.jettyFactory = jettyFactory;
        this.configuration = null;
        this.state = new Unconfigured();
        this.listeners = new CopyOnWriteArraySet<ServerListener>();
    }

    public synchronized void start() {
        LOG.debug("Starting server [{}]", (Object)this);
        this.state.start();
    }

    public synchronized void stop() {
        LOG.debug("Stopping server [{}]", (Object)this);
        this.state.stop();
    }

    public synchronized void configure(Configuration configuration) {
        LOG.debug("Configuring server [{}] -> [{}] ", (Object)this, (Object)configuration);
        if (configuration == null) {
            throw new IllegalArgumentException("configuration == null");
        }
        this.configuration = configuration;
        this.state.configure();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addListener(ServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    public void addServlet(ServletModel model) {
        this.state.addServlet(model);
    }

    public void removeServlet(ServletModel model) {
        this.state.removeServlet(model);
    }

    public boolean isStarted() {
        return this.state instanceof Started;
    }

    public boolean isConfigured() {
        return !(this.state instanceof Unconfigured);
    }

    public void addEventListener(EventListenerModel eventListenerModel) {
        this.state.addEventListener(eventListenerModel);
    }

    public void removeEventListener(EventListenerModel eventListenerModel) {
        this.state.removeEventListener(eventListenerModel);
    }

    public void removeContext(HttpContext httpContext) {
        this.state.removeContext(httpContext);
    }

    public void addFilter(FilterModel filterModel) {
        this.state.addFilter(filterModel);
    }

    public void removeFilter(FilterModel filterModel) {
        this.state.removeFilter(filterModel);
    }

    public void addErrorPage(ErrorPageModel model) {
        this.state.addErrorPage(model);
    }

    public void removeErrorPage(ErrorPageModel model) {
        this.state.removeErrorPage(model);
    }

    public LifeCycle getContext(ContextModel model) {
        return this.state.getContext(model);
    }

    public void addSecurityConstraintMapping(SecurityConstraintMappingModel model) {
        this.state.addSecurityConstraintMapping(model);
    }

    public void addContainerInitializerModel(ContainerInitializerModel model) {
        this.state.addContainerInitializerModel(model);
    }

    public Integer getHttpPort() {
        if (this.httpConnector != null && this.httpConnector.isStarted()) {
            return this.httpConnector.getLocalPort();
        }
        return this.configuration.getHttpPort();
    }

    public Integer getHttpSecurePort() {
        if (this.httpSecureConnector != null && this.httpSecureConnector.isStarted()) {
            return this.httpSecureConnector.getLocalPort();
        }
        return this.configuration.getHttpSecurePort();
    }

    public Servlet createResourceServlet(ContextModel contextModel, String alias, String name) {
        return new ResourceServlet(contextModel.getHttpContext(), contextModel.getContextName(), alias, name);
    }

    void notifyListeners(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public String toString() {
        return ServerControllerImpl.class.getSimpleName() + "{" + "state=" + this.state + "}";
    }

    private class Unconfigured
    extends Stopped {
        private Unconfigured() {
        }

        @Override
        public void start() {
            throw new IllegalStateException("server is not yet configured.");
        }

        @Override
        public void configure() {
            ServerControllerImpl.this.state = new Stopped();
            ServerControllerImpl.this.notifyListeners(ServerEvent.CONFIGURED);
            ServerControllerImpl.this.start();
        }

        @Override
        public String toString() {
            return "UNCONFIGURED";
        }
    }

    private class Stopped
    implements State {
        Stopped() {
            ServerControllerImpl.this.httpConnector = null;
            ServerControllerImpl.this.httpSecureConnector = null;
        }

        @Override
        public void start() {
            ServerControllerImpl.this.jettyServer = ServerControllerImpl.this.jettyFactory.createServer();
            ServerControllerImpl.this.httpConnector = null;
            ServerControllerImpl.this.httpSecureConnector = null;
            String[] addresses = ServerControllerImpl.this.configuration.getListeningAddresses();
            if (addresses == null || addresses.length == 0) {
                addresses = new String[]{null};
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("javax.servlet.context.tempdir", ServerControllerImpl.this.configuration.getTemporaryDirectory());
            ServerControllerImpl.this.jettyServer.setServerConfigDir(ServerControllerImpl.this.configuration.getConfigurationDir());
            ServerControllerImpl.this.jettyServer.setServerConfigURL(ServerControllerImpl.this.configuration.getConfigurationURL());
            ServerControllerImpl.this.jettyServer.configureContext(attributes, ServerControllerImpl.this.configuration.getSessionTimeout(), ServerControllerImpl.this.configuration.getSessionCookie(), ServerControllerImpl.this.configuration.getSessionDomain(), ServerControllerImpl.this.configuration.getSessionUrl(), ServerControllerImpl.this.configuration.getSessionCookieHttpOnly(), ServerControllerImpl.this.configuration.getSessionCookieSecure(), ServerControllerImpl.this.configuration.getWorkerName(), ServerControllerImpl.this.configuration.getSessionLazyLoad(), ServerControllerImpl.this.configuration.getSessionStoreDirectory());
            if (ServerControllerImpl.this.configuration.isLogNCSAFormatEnabled().booleanValue()) {
                ServerControllerImpl.this.jettyServer.configureRequestLog(new ConfigureRequestLogParameter(ServerControllerImpl.this.configuration.getLogNCSAFormat(), ServerControllerImpl.this.configuration.getLogNCSARetainDays(), ServerControllerImpl.this.configuration.isLogNCSAAppend(), ServerControllerImpl.this.configuration.isLogNCSAExtended(), ServerControllerImpl.this.configuration.isLogNCSADispatch(), ServerControllerImpl.this.configuration.getLogNCSATimeZone(), ServerControllerImpl.this.configuration.getLogNCSADirectory(), ServerControllerImpl.this.configuration.isLogNCSALatency(), ServerControllerImpl.this.configuration.isLogNCSACookies(), ServerControllerImpl.this.configuration.isLogNCSAServer()));
            }
            ServerControllerImpl.this.jettyServer.start();
            for (String address : addresses) {
                Connector[] connectors;
                Integer httpPort = ServerControllerImpl.this.configuration.getHttpPort();
                Boolean useNIO = ServerControllerImpl.this.configuration.useNIO();
                Boolean checkForwaredHeaders = ServerControllerImpl.this.configuration.checkForwardedHeaders();
                Integer httpSecurePort = ServerControllerImpl.this.configuration.getHttpSecurePort();
                if (ServerControllerImpl.this.configuration.isHttpEnabled().booleanValue()) {
                    connectors = ServerControllerImpl.this.jettyServer.getConnectors();
                    boolean masterConnectorFound = false;
                    if (connectors != null && connectors.length > 0) {
                        Connector backupConnector = null;
                        for (Connector connector : connectors) {
                            if (!(connector instanceof Connector) || connector instanceof SslConnector) continue;
                            if (this.match(address, httpPort, connector)) {
                                if (ServerControllerImpl.this.httpConnector == null) {
                                    ServerControllerImpl.this.httpConnector = connector;
                                }
                                if (!connector.isStarted()) {
                                    this.startConnector(connector);
                                }
                                masterConnectorFound = true;
                                continue;
                            }
                            if (backupConnector == null) {
                                backupConnector = connector;
                            }
                            if (connector.isStarted()) continue;
                            this.startConnector(connector);
                        }
                        if (ServerControllerImpl.this.httpConnector == null && backupConnector != null) {
                            ServerControllerImpl.this.httpConnector = backupConnector;
                        }
                    }
                    if (!masterConnectorFound) {
                        Connector connector = ServerControllerImpl.this.jettyFactory.createConnector(ServerControllerImpl.this.configuration.getHttpConnectorName(), httpPort, address, useNIO, checkForwaredHeaders);
                        if (ServerControllerImpl.this.httpConnector == null) {
                            ServerControllerImpl.this.httpConnector = connector;
                        }
                        ServerControllerImpl.this.jettyServer.addConnector(connector);
                        this.startConnector(connector);
                    }
                } else {
                    connectors = ServerControllerImpl.this.jettyServer.getConnectors();
                    if (connectors != null) {
                        for (Connector connector : connectors) {
                            if (!(connector instanceof Connector) || connector instanceof SslConnector) continue;
                            LOG.warn(String.format("HTTP is not enabled in Pax Web configuration - removing connector: %s", connector));
                            this.stopConnector(connector);
                            ServerControllerImpl.this.jettyServer.removeConnector(connector);
                        }
                    }
                }
                if (ServerControllerImpl.this.configuration.isHttpSecureEnabled().booleanValue()) {
                    String sslPassword = ServerControllerImpl.this.configuration.getSslPassword();
                    String sslKeyPassword = ServerControllerImpl.this.configuration.getSslKeyPassword();
                    Connector[] connectors2 = ServerControllerImpl.this.jettyServer.getConnectors();
                    boolean masterSSLConnectorFound = false;
                    if (connectors2 != null && connectors2.length > 0) {
                        Connector backupConnector = null;
                        for (Connector connector : connectors2) {
                            if (!(connector instanceof SslConnector)) continue;
                            if (this.match(address, httpSecurePort, connector)) {
                                SslConnector sslCon = (SslConnector)connector;
                                ServerControllerImpl.this.httpSecureConnector = (Connector)sslCon;
                                if (!sslCon.isStarted()) {
                                    this.startConnector((Connector)sslCon);
                                }
                                masterSSLConnectorFound = true;
                                continue;
                            }
                            if (backupConnector == null) {
                                backupConnector = connector;
                            }
                            if (connector.isStarted()) continue;
                            this.startConnector(connector);
                        }
                        if (ServerControllerImpl.this.httpSecureConnector == null && backupConnector != null) {
                            ServerControllerImpl.this.httpSecureConnector = backupConnector;
                        }
                    }
                    if (masterSSLConnectorFound) continue;
                    if (sslPassword != null && sslKeyPassword != null) {
                        Connector secureConnector = ServerControllerImpl.this.jettyFactory.createSecureConnector(ServerControllerImpl.this.configuration.getHttpSecureConnectorName(), httpSecurePort, ServerControllerImpl.this.configuration.getSslKeystore(), sslPassword, sslKeyPassword, address, ServerControllerImpl.this.configuration.getSslKeystoreType(), ServerControllerImpl.this.configuration.isClientAuthNeeded(), ServerControllerImpl.this.configuration.isClientAuthWanted(), ServerControllerImpl.this.configuration.useNIO());
                        if (ServerControllerImpl.this.httpSecureConnector == null) {
                            ServerControllerImpl.this.httpSecureConnector = secureConnector;
                        }
                        ServerControllerImpl.this.jettyServer.addConnector(secureConnector);
                        this.startConnector(secureConnector);
                        continue;
                    }
                    LOG.warn("SSL password and SSL keystore password must be set in order to enable SSL.");
                    LOG.warn("SSL connector will not be started");
                    continue;
                }
                connectors = ServerControllerImpl.this.jettyServer.getConnectors();
                if (connectors == null) continue;
                for (Connector connector : connectors) {
                    if (!(connector instanceof SslConnector)) continue;
                    LOG.warn(String.format("HTTPS is not enabled in Pax Web configuration - removing connector: %s", connector));
                    this.stopConnector(connector);
                    ServerControllerImpl.this.jettyServer.removeConnector(connector);
                }
            }
            ServerControllerImpl.this.state = new Started();
            ServerControllerImpl.this.notifyListeners(ServerEvent.STARTED);
        }

        private boolean match(String address, Integer httpPort, Connector connector) {
            InetSocketAddress isa1 = address != null ? new InetSocketAddress(address, (int)httpPort) : new InetSocketAddress(httpPort);
            InetSocketAddress isa2 = connector.getHost() != null ? new InetSocketAddress(connector.getHost(), connector.getPort()) : new InetSocketAddress(connector.getPort());
            return isa1.equals(isa2);
        }

        private void startConnector(Connector connector) {
            try {
                connector.start();
            }
            catch (Exception e) {
                LOG.warn("Http connector will not be started", (Throwable)e);
            }
        }

        private void stopConnector(Connector connector) {
            try {
                connector.stop();
            }
            catch (Exception e) {
                LOG.warn("Connector " + connector + " could not be stopped", (Throwable)e);
            }
        }

        @Override
        public void stop() {
        }

        @Override
        public void configure() {
            ServerControllerImpl.this.notifyListeners(ServerEvent.CONFIGURED);
        }

        @Override
        public void addServlet(ServletModel model) {
        }

        @Override
        public void removeServlet(ServletModel model) {
        }

        @Override
        public void addEventListener(EventListenerModel eventListenerModel) {
        }

        @Override
        public void removeEventListener(EventListenerModel eventListenerModel) {
        }

        @Override
        public void removeContext(HttpContext httpContext) {
        }

        @Override
        public void addFilter(FilterModel filterModel) {
        }

        @Override
        public void removeFilter(FilterModel filterModel) {
        }

        @Override
        public void addErrorPage(ErrorPageModel model) {
        }

        @Override
        public void removeErrorPage(ErrorPageModel model) {
        }

        @Override
        public void removeSecurityConstraintMappings(SecurityConstraintMappingModel model) {
        }

        public void addLoginConfig(LoginConfigModel model) {
        }

        public void removeLoginConfig(LoginConfigModel model) {
        }

        @Override
        public void addSecurityConstraintMapping(SecurityConstraintMappingModel model) {
        }

        @Override
        public LifeCycle getContext(ContextModel model) {
            return null;
        }

        public String toString() {
            return "STOPPED";
        }

        @Override
        public void addContainerInitializerModel(ContainerInitializerModel model) {
        }
    }

    private class Started
    implements State {
        private Started() {
        }

        @Override
        public void start() {
            throw new IllegalStateException("server is already started. must be stopped first.");
        }

        @Override
        public void stop() {
            ServerControllerImpl.this.jettyServer.stop();
            ServerControllerImpl.this.state = new Stopped();
            ServerControllerImpl.this.notifyListeners(ServerEvent.STOPPED);
        }

        @Override
        public void configure() {
            ServerControllerImpl.this.stop();
            ServerControllerImpl.this.start();
        }

        @Override
        public void addServlet(ServletModel model) {
            ServerControllerImpl.this.jettyServer.addServlet(model);
        }

        @Override
        public void removeServlet(ServletModel model) {
            ServerControllerImpl.this.jettyServer.removeServlet(model);
        }

        @Override
        public void addEventListener(EventListenerModel eventListenerModel) {
            ServerControllerImpl.this.jettyServer.addEventListener(eventListenerModel);
        }

        @Override
        public void removeEventListener(EventListenerModel eventListenerModel) {
            ServerControllerImpl.this.jettyServer.removeEventListener(eventListenerModel);
        }

        @Override
        public void removeContext(HttpContext httpContext) {
            ServerControllerImpl.this.jettyServer.removeContext(httpContext);
        }

        @Override
        public void addFilter(FilterModel filterModel) {
            ServerControllerImpl.this.jettyServer.addFilter(filterModel);
        }

        @Override
        public void removeFilter(FilterModel filterModel) {
            ServerControllerImpl.this.jettyServer.removeFilter(filterModel);
        }

        @Override
        public void addErrorPage(ErrorPageModel model) {
            ServerControllerImpl.this.jettyServer.addErrorPage(model);
        }

        @Override
        public void removeErrorPage(ErrorPageModel model) {
            ServerControllerImpl.this.jettyServer.removeErrorPage(model);
        }

        @Override
        public void removeSecurityConstraintMappings(SecurityConstraintMappingModel model) {
            ServerControllerImpl.this.jettyServer.removeSecurityConstraintMappings(model);
        }

        @Override
        public void addSecurityConstraintMapping(SecurityConstraintMappingModel model) {
            ServerControllerImpl.this.jettyServer.addSecurityConstraintMappings(model);
        }

        @Override
        public LifeCycle getContext(ContextModel model) {
            return ServerControllerImpl.this.jettyServer.getContext(model);
        }

        public String toString() {
            return "STARTED";
        }

        @Override
        public void addContainerInitializerModel(ContainerInitializerModel model) {
            ServerControllerImpl.this.jettyServer.addServletContainerInitializer(model);
        }
    }

    private static interface State {
        public void start();

        public void addContainerInitializerModel(ContainerInitializerModel var1);

        public void addSecurityConstraintMapping(SecurityConstraintMappingModel var1);

        public void removeSecurityConstraintMappings(SecurityConstraintMappingModel var1);

        public void stop();

        public void configure();

        public void addServlet(ServletModel var1);

        public void removeServlet(ServletModel var1);

        public void addEventListener(EventListenerModel var1);

        public void removeEventListener(EventListenerModel var1);

        public void removeContext(HttpContext var1);

        public void addFilter(FilterModel var1);

        public void removeFilter(FilterModel var1);

        public void addErrorPage(ErrorPageModel var1);

        public void removeErrorPage(ErrorPageModel var1);

        public LifeCycle getContext(ContextModel var1);
    }
}

