/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent;

import io.fabric8.fab.osgi.FabBundleInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public interface StreamProvider {
    public InputStream open() throws IOException;

    public static class Fab
    implements StreamProvider {
        private final FabBundleInfo fab;

        public Fab(FabBundleInfo fab) {
            this.fab = fab;
        }

        @Override
        public InputStream open() throws IOException {
            try {
                return this.fab.getInputStream();
            }
            catch (Exception e) {
                throw new IOException("Unable to create input stream for fab", e);
            }
        }
    }

    public static class File
    implements StreamProvider {
        private final java.io.File file;

        public File(java.io.File file) {
            this.file = file;
        }

        @Override
        public InputStream open() throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

