/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import io.fabric8.agent.resolver.CapabilityImpl;
import io.fabric8.agent.resolver.ResourceBuilder;
import io.fabric8.agent.resolver.SimpleFilter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.resource.Capability;

public class CapabilitySet {
    private final Map<String, Map<Object, Set<Capability>>> m_indices;
    private final Set<Capability> m_capSet = new HashSet<Capability>();
    private static final Class<?>[] STRING_CLASS = new Class[]{String.class};

    public void dump() {
        for (Map.Entry<String, Map<Object, Set<Capability>>> entry : this.m_indices.entrySet()) {
            boolean header1 = false;
            for (Map.Entry<Object, Set<Capability>> entry2 : entry.getValue().entrySet()) {
                boolean header2 = false;
                for (Capability cap : entry2.getValue()) {
                    if (!header1) {
                        System.out.println(entry.getKey() + ":");
                        header1 = true;
                    }
                    if (!header2) {
                        System.out.println("   " + entry2.getKey());
                        header2 = true;
                    }
                    System.out.println("      " + cap);
                }
            }
        }
    }

    public CapabilitySet(List<String> indexProps) {
        this.m_indices = new TreeMap<String, Map<Object, Set<Capability>>>();
        for (int i = 0; indexProps != null && i < indexProps.size(); ++i) {
            this.m_indices.put(indexProps.get(i), new HashMap());
        }
    }

    public void addCapability(Capability cap) {
        this.m_capSet.add(cap);
        for (Map.Entry<String, Map<Object, Set<Capability>>> entry : this.m_indices.entrySet()) {
            Object value = cap.getAttributes().get(entry.getKey());
            if (value == null) continue;
            if (value.getClass().isArray()) {
                value = CapabilitySet.convertArrayToList(value);
            }
            Map<Object, Set<Capability>> index = entry.getValue();
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                for (Object o : c) {
                    this.indexCapability(index, cap, o);
                }
                continue;
            }
            this.indexCapability(index, cap, value);
        }
    }

    private void indexCapability(Map<Object, Set<Capability>> index, Capability cap, Object capValue) {
        Set<Capability> caps = index.get(capValue);
        if (caps == null) {
            caps = new HashSet<Capability>();
            index.put(capValue, caps);
        }
        caps.add(cap);
    }

    public void removeCapability(Capability cap) {
        if (this.m_capSet.remove(cap)) {
            for (Map.Entry<String, Map<Object, Set<Capability>>> entry : this.m_indices.entrySet()) {
                Object value = cap.getAttributes().get(entry.getKey());
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    value = CapabilitySet.convertArrayToList(value);
                }
                Map<Object, Set<Capability>> index = entry.getValue();
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object o : c) {
                        this.deindexCapability(index, cap, o);
                    }
                    continue;
                }
                this.deindexCapability(index, cap, value);
            }
        }
    }

    private void deindexCapability(Map<Object, Set<Capability>> index, Capability cap, Object value) {
        Set<Capability> caps = index.get(value);
        if (caps != null) {
            caps.remove(cap);
            if (caps.isEmpty()) {
                index.remove(value);
            }
        }
    }

    public Set<Capability> match(SimpleFilter sf, boolean obeyMandatory) {
        Set<Capability> matches = this.match(this.m_capSet, sf);
        return obeyMandatory ? CapabilitySet.matchMandatory(matches, sf) : matches;
    }

    private Set<Capability> match(Set<Capability> caps, SimpleFilter sf) {
        Set<Capability> matches;
        block5: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                matches = new HashSet<Capability>();
                                if (sf.getOperation() != 0) break block4;
                                matches.addAll(caps);
                                break block5;
                            }
                            if (sf.getOperation() != 1) break block6;
                            List sfs = (List)sf.getValue();
                            for (int i = 0; caps.size() > 0 && i < sfs.size(); ++i) {
                                matches = this.match(caps, (SimpleFilter)sfs.get(i));
                                caps = matches;
                            }
                            break block5;
                        }
                        if (sf.getOperation() != 2) break block7;
                        List sfs = (List)sf.getValue();
                        for (int i = 0; i < sfs.size(); ++i) {
                            matches.addAll(this.match(caps, (SimpleFilter)sfs.get(i)));
                        }
                        break block5;
                    }
                    if (sf.getOperation() != 3) break block8;
                    matches.addAll(caps);
                    List sfs = (List)sf.getValue();
                    for (int i = 0; i < sfs.size(); ++i) {
                        matches.removeAll(this.match(caps, (SimpleFilter)sfs.get(i)));
                    }
                    break block5;
                }
                Map<Object, Set<Capability>> index = this.m_indices.get(sf.getName());
                if (sf.getOperation() != 4 || index == null) break block9;
                Set<Capability> existingCaps = index.get(sf.getValue());
                if (existingCaps == null) break block5;
                matches.addAll(existingCaps);
                matches.retainAll(caps);
                break block5;
            }
            for (Capability cap : caps) {
                Object lhs = cap.getAttributes().get(sf.getName());
                if (lhs == null || !CapabilitySet.compare(lhs, sf.getValue(), sf.getOperation())) continue;
                matches.add(cap);
            }
        }
        return matches;
    }

    public static boolean matches(Capability cap, SimpleFilter sf) {
        return CapabilitySet.matchesInternal(cap, sf) && CapabilitySet.matchMandatory(cap, sf);
    }

    private static boolean matchesInternal(Capability cap, SimpleFilter sf) {
        boolean matched = true;
        if (sf.getOperation() == 0) {
            matched = true;
        } else if (sf.getOperation() == 1) {
            List sfs = (List)sf.getValue();
            for (int i = 0; matched && i < sfs.size(); ++i) {
                matched = CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 2) {
            matched = false;
            List sfs = (List)sf.getValue();
            for (int i = 0; !matched && i < sfs.size(); ++i) {
                matched = CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else if (sf.getOperation() == 3) {
            List sfs = (List)sf.getValue();
            for (int i = 0; i < sfs.size(); ++i) {
                matched = !CapabilitySet.matchesInternal(cap, (SimpleFilter)sfs.get(i));
            }
        } else {
            matched = false;
            Object lhs = cap.getAttributes().get(sf.getName());
            if (lhs != null) {
                matched = CapabilitySet.compare(lhs, sf.getValue(), sf.getOperation());
            }
        }
        return matched;
    }

    private static Set<Capability> matchMandatory(Set<Capability> caps, SimpleFilter sf) {
        Iterator<Capability> it = caps.iterator();
        while (it.hasNext()) {
            Capability cap = it.next();
            if (CapabilitySet.matchMandatory(cap, sf)) continue;
            it.remove();
        }
        return caps;
    }

    private static boolean matchMandatory(Capability cap, SimpleFilter sf) {
        block3: {
            block2: {
                if (!(cap instanceof CapabilityImpl)) break block2;
                for (Map.Entry entry : cap.getAttributes().entrySet()) {
                    if (!((CapabilityImpl)cap).isAttributeMandatory((String)entry.getKey()) || CapabilitySet.matchMandatoryAttribute((String)entry.getKey(), sf)) continue;
                    return false;
                }
                break block3;
            }
            String value = (String)cap.getDirectives().get("mandatory");
            if (value == null) break block3;
            List<String> names = ResourceBuilder.parseDelimitedString(value, ",");
            for (Map.Entry entry : cap.getAttributes().entrySet()) {
                if (!names.contains(entry.getKey()) || CapabilitySet.matchMandatoryAttribute((String)entry.getKey(), sf)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchMandatoryAttribute(String attrName, SimpleFilter sf) {
        if (sf.getName() != null && sf.getName().equals(attrName)) {
            return true;
        }
        if (sf.getOperation() == 1) {
            List list = (List)sf.getValue();
            for (int i = 0; i < list.size(); ++i) {
                SimpleFilter sf2 = (SimpleFilter)list.get(i);
                if (sf2.getName() == null || !sf2.getName().equals(attrName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean compare(Object lhs, Object rhsUnknown, int op) {
        if (lhs == null) {
            return false;
        }
        if (op == 8) {
            return true;
        }
        if (lhs instanceof Comparable) {
            Object rhs;
            if (op == 7 && !(lhs instanceof String)) {
                return false;
            }
            if (op == 7) {
                rhs = rhsUnknown;
            } else {
                try {
                    rhs = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            switch (op) {
                case 4: {
                    try {
                        return ((Comparable)lhs).compareTo(rhs) == 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 6: {
                    try {
                        return ((Comparable)lhs).compareTo(rhs) >= 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 5: {
                    try {
                        return ((Comparable)lhs).compareTo(rhs) <= 0;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                case 9: {
                    return CapabilitySet.compareApproximate((Comparable)lhs, rhs);
                }
                case 7: {
                    return SimpleFilter.compareSubstring((List)rhs, (String)lhs);
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + op);
        }
        if (lhs instanceof Boolean) {
            Object rhs;
            try {
                rhs = CapabilitySet.coerceType(lhs, (String)rhsUnknown);
            }
            catch (Exception ex) {
                return false;
            }
            switch (op) {
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    return lhs.equals(rhs);
                }
            }
            throw new RuntimeException("Unknown comparison operator: " + op);
        }
        if (lhs.getClass().isArray()) {
            lhs = CapabilitySet.convertArrayToList(lhs);
        }
        if (lhs instanceof Collection) {
            Iterator iter = ((Collection)lhs).iterator();
            while (iter.hasNext()) {
                if (!CapabilitySet.compare(iter.next(), rhsUnknown, op)) continue;
                return true;
            }
            return false;
        }
        if (op == 7 && !(lhs instanceof String)) {
            return false;
        }
        try {
            return lhs.equals(CapabilitySet.coerceType(lhs, (String)rhsUnknown));
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean compareApproximate(Object lhs, Object rhs) {
        if (rhs instanceof String) {
            return CapabilitySet.removeWhitespace((String)lhs).equalsIgnoreCase(CapabilitySet.removeWhitespace((String)rhs));
        }
        if (rhs instanceof Character) {
            return Character.toLowerCase(((Character)lhs).charValue()) == Character.toLowerCase(((Character)rhs).charValue());
        }
        return lhs.equals(rhs);
    }

    private static String removeWhitespace(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private static Object coerceType(Object lhs, String rhsString) throws Exception {
        if (lhs.getClass() == rhsString.getClass()) {
            return rhsString;
        }
        Character rhs = null;
        try {
            if (lhs instanceof Character) {
                rhs = new Character(rhsString.charAt(0));
            } else {
                if (lhs instanceof Number || lhs instanceof Boolean) {
                    rhsString = rhsString.trim();
                }
                Constructor<?> ctor = lhs.getClass().getConstructor(STRING_CLASS);
                ctor.setAccessible(true);
                rhs = ctor.newInstance(rhsString);
            }
        }
        catch (Exception ex) {
            throw new Exception("Could not instantiate class " + lhs.getClass().getName() + " from string constructor with argument '" + rhsString + "' because " + ex);
        }
        return rhs;
    }

    private static List convertArrayToList(Object array) {
        int len = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }
}

