/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.service.http.HttpContext;

public class ServiceModel {
    private final Map<String, ServletModel> aliasMapping = new HashMap<String, ServletModel>();
    private final Set<ServletModel> servletModels = new HashSet<ServletModel>();
    private final Map<Filter, FilterModel> filterModels = new LinkedHashMap<Filter, FilterModel>();
    private final Map<EventListener, EventListenerModel> eventListenerModels = new HashMap<EventListener, EventListenerModel>();
    private final Map<String, LoginConfigModel> loginConfigModels;
    private final Map<String, ErrorPageModel> errorPageModels = new HashMap<String, ErrorPageModel>();
    private final Map<HttpContext, ContextModel> contextModels = new HashMap<HttpContext, ContextModel>();
    private final Map<String, SecurityConstraintMappingModel> securityConstraintMappingModels;
    private final Map<ServletContainerInitializer, ContainerInitializerModel> containerInitializers;

    public ServiceModel() {
        this.loginConfigModels = new HashMap<String, LoginConfigModel>();
        this.securityConstraintMappingModels = new HashMap<String, SecurityConstraintMappingModel>();
        this.containerInitializers = new HashMap<ServletContainerInitializer, ContainerInitializerModel>();
    }

    public synchronized ServletModel getServletModelWithAlias(String alias) {
        NullArgumentException.validateNotEmpty(alias, "Alias");
        return this.aliasMapping.get(alias);
    }

    public synchronized void addServletModel(ServletModel model) {
        if (model.getAlias() != null) {
            this.aliasMapping.put(model.getAlias(), model);
        }
        this.servletModels.add(model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized void removeServletModel(ServletModel model) {
        if (model.getAlias() != null) {
            this.aliasMapping.remove(model.getAlias());
        }
        this.servletModels.remove(model);
    }

    public synchronized ServletModel removeServlet(Servlet servlet) {
        ServletModel model = this.findServletModel(servlet);
        if (model == null) {
            throw new IllegalArgumentException("Servlet [" + servlet + " is not currently registered in any context");
        }
        this.servletModels.remove(servlet);
        return model;
    }

    private synchronized ServletModel findServletModel(Servlet servlet) {
        for (ServletModel servletModel : this.servletModels) {
            if (servletModel.getServlet() == null || !servletModel.getServlet().equals(servlet)) continue;
            return servletModel;
        }
        return null;
    }

    public synchronized Set<ServletModel> removeServletClass(Class<? extends Servlet> servletClass) {
        Set<ServletModel> models = this.findServletModels(servletClass);
        if (models == null) {
            throw new IllegalArgumentException("Servlet class [" + servletClass + " is not currently registered in any context");
        }
        this.servletModels.removeAll(models);
        return models;
    }

    private synchronized Set<ServletModel> findServletModels(Class<? extends Servlet> servletClass) {
        HashSet<ServletModel> foundServletModels = null;
        for (ServletModel servletModel : this.servletModels) {
            if (servletModel.getServletClass() == null || !servletModel.getServletClass().equals(servletClass)) continue;
            if (foundServletModels == null) {
                foundServletModels = new HashSet<ServletModel>();
            }
            foundServletModels.add(servletModel);
        }
        return foundServletModels;
    }

    public synchronized void addEventListenerModel(EventListenerModel model) {
        if (this.eventListenerModels.containsKey(model.getEventListener())) {
            throw new IllegalArgumentException("Listener [" + model.getEventListener() + "] already registered.");
        }
        this.eventListenerModels.put(model.getEventListener(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized EventListenerModel removeEventListener(EventListener listener) {
        EventListenerModel model = this.eventListenerModels.get(listener);
        if (model == null) {
            throw new IllegalArgumentException("Listener [" + listener + " is not currently registered in any context");
        }
        this.eventListenerModels.remove(listener);
        return model;
    }

    public synchronized void addFilterModel(FilterModel model) {
        if (this.filterModels.containsKey(model.getFilter())) {
            throw new IllegalArgumentException("Filter [" + model.getFilter() + "] is already registered.");
        }
        this.filterModels.put(model.getFilter(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized FilterModel removeFilter(Filter filter) {
        FilterModel model = this.filterModels.get(filter);
        if (model == null) {
            throw new IllegalArgumentException("Filter [" + filter + " is not currently registered in any context");
        }
        this.filterModels.remove(filter);
        return model;
    }

    public synchronized ServletModel[] getServletModels() {
        return this.servletModels.toArray(new ServletModel[this.servletModels.size()]);
    }

    public synchronized EventListenerModel[] getEventListenerModels() {
        Collection<EventListenerModel> models = this.eventListenerModels.values();
        return models.toArray(new EventListenerModel[models.size()]);
    }

    public synchronized FilterModel[] getFilterModels() {
        Collection<FilterModel> models = this.filterModels.values();
        return models.toArray(new FilterModel[models.size()]);
    }

    public synchronized ErrorPageModel[] getErrorPageModels() {
        Collection<ErrorPageModel> models = this.errorPageModels.values();
        return models.toArray(new ErrorPageModel[models.size()]);
    }

    public synchronized void addContextModel(ContextModel contextModel) {
        if (!this.contextModels.containsKey(contextModel.getHttpContext())) {
            this.contextModels.put(contextModel.getHttpContext(), contextModel);
        }
    }

    public synchronized ContextModel[] getContextModels() {
        Collection<ContextModel> contextModelValues = this.contextModels.values();
        if (contextModelValues == null || contextModelValues.size() == 0) {
            return new ContextModel[0];
        }
        return contextModelValues.toArray(new ContextModel[contextModelValues.size()]);
    }

    public synchronized ContextModel getContextModel(HttpContext httpContext) {
        return this.contextModels.get(httpContext);
    }

    public synchronized void addErrorPageModel(ErrorPageModel model) {
        String key = model.getError() + "|" + model.getContextModel().getId();
        if (this.errorPageModels.containsKey(key)) {
            throw new IllegalArgumentException("Error page for [" + model.getError() + "] already registered.");
        }
        this.errorPageModels.put(key, model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized ErrorPageModel removeErrorPage(String error, ContextModel contextModel) {
        String key = error + "|" + contextModel.getId();
        ErrorPageModel model = this.errorPageModels.get(key);
        if (model == null) {
            throw new IllegalArgumentException("Error page for [" + error + "] cannot be found in the provided http context");
        }
        this.errorPageModels.remove(key);
        return model;
    }

    public synchronized void addLoginModel(LoginConfigModel model) {
        if (this.loginConfigModels.containsKey(model.getRealmName())) {
            throw new IllegalArgumentException("Login Config [" + model.getRealmName() + "] is already registered.");
        }
        this.loginConfigModels.put(model.getRealmName(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized LoginConfigModel[] getLoginModels() {
        Collection<LoginConfigModel> loginModels = this.loginConfigModels.values();
        return loginModels.toArray(new LoginConfigModel[loginModels.size()]);
    }

    public synchronized void addSecurityConstraintMappingModel(SecurityConstraintMappingModel model) {
        if (this.securityConstraintMappingModels.containsKey(model.getConstraintName())) {
            throw new IllegalArgumentException("Security Mapping [" + model.getConstraintName() + "] is already registered.");
        }
        this.securityConstraintMappingModels.put(model.getConstraintName(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized SecurityConstraintMappingModel[] getSecurityConstraintMappings() {
        Collection<SecurityConstraintMappingModel> collection = this.securityConstraintMappingModels.values();
        return collection.toArray(new SecurityConstraintMappingModel[collection.size()]);
    }

    public synchronized void addContainerInitializerModel(ContainerInitializerModel model) {
        if (this.containerInitializers.containsKey(model.getContainerInitializer())) {
            throw new IllegalArgumentException("ServletContainerInitializer " + model.getContainerInitializer() + " already registered");
        }
        this.containerInitializers.put(model.getContainerInitializer(), model);
    }

    public synchronized void removeContainerInitializerModel(ContainerInitializerModel model) {
    }

    public synchronized boolean canBeConfigured(HttpContext httpContext) {
        return this.canBeConfigured(httpContext, this.servletModels) && this.canBeConfigured(httpContext, this.filterModels.values()) && this.canBeConfigured(httpContext, this.eventListenerModels.values()) && this.canBeConfigured(httpContext, this.errorPageModels.values()) && this.canBeConfigured(httpContext, this.loginConfigModels.values());
    }

    private boolean canBeConfigured(HttpContext httpContext, Collection<? extends Model> models) {
        for (Model model : models) {
            ContextModel contextModel = model.getContextModel();
            HttpContext candidateHttpContext = contextModel.getHttpContext();
            if (!candidateHttpContext.equals(httpContext)) continue;
            return false;
        }
        return true;
    }
}

