/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.boot.commands;

import com.google.common.base.Strings;
import io.fabric8.api.ContainerOptions;
import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DefaultRuntimeProperties;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ServiceProxy;
import io.fabric8.api.ZooKeeperClusterBootstrap;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.utils.shell.ShellUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.shell.console.AbstractAction;
import org.osgi.framework.BundleContext;

@Command(name="create", scope="fabric", description="Creates a new fabric ensemble (ZooKeeper ensemble) and imports fabric profiles", detailedDescription="classpath:create.txt")
final class CreateAction
extends AbstractAction {
    private static final String GIT_EXTERNAL_URL = "gitExternalUrl";
    private static final String GIT_REMOTE_USER = "gitRemoteUser";
    private static final String GIT_REMOTE_PASSWORD = "gitRemotePassword";
    @Option(name="--clean", description="Clean local zookeeper cluster and configurations")
    private boolean clean;
    @Option(name="--no-import", description="Disable the import of the sample registry data")
    private boolean noImport;
    @Option(name="--import-dir", description="Directory of files to import into the newly created ensemble")
    private String importDir = CreateAction.getDefaultImportDir();
    @Option(name="-v", aliases={"--verbose"}, description="Flag to enable verbose output of files being imported")
    boolean verbose = false;
    @Option(name="-g", aliases={"--global-resolver"}, description="The global resolver policy, which becomes the default resolver policy applied to all new containers created in this fabric. Possible values are: localip, localhostname, publicip, publichostname, manualip. Default is localhostname.")
    String globalResolver;
    @Option(name="-r", aliases={"--resolver"}, description="The local resolver policy. Possible values are: localip, localhostname, publicip, publichostname, manualip. Default is localhostname.")
    String resolver;
    @Option(name="-m", aliases={"--manual-ip"}, description="An address to use, when using the manualip resolver.")
    String manualIp;
    @Option(name="-b", aliases={"--bind-address"}, description="The default bind address.")
    String bindAddress;
    @Option(name="-n", aliases={"--non-managed"}, multiValued=false, description="Flag to keep the container non managed")
    private boolean nonManaged;
    @Option(name="--wait-for-provisioning", multiValued=false, description="Flag to wait for the initial container provisioning")
    private boolean waitForProvisioning = false;
    @Option(name="--bootstrap-timeout", multiValued=false, description="How long to wait (milliseconds) for the initial fabric bootstrap")
    private long bootstrapTimeout = 120000L;
    @Option(name="-t", aliases={"--time"}, description="How long to wait (milliseconds) for the ensemble to start up before trying to import the default data")
    long ensembleStartupTime = 2000L;
    @Option(name="-p", aliases={"--profile"}, multiValued=true, description="Chooses the profile of the container.")
    private Set<String> profiles = null;
    @Option(name="-v", aliases={"--version"}, multiValued=false, description="Chooses the default version.")
    private String version = ContainerOptions.DEFAULT_VERSION;
    @Option(name="--min-port", multiValued=false, description="The minimum port of the allowed port range")
    private int minimumPort = 0;
    @Option(name="--max-port", multiValued=false, description="The maximum port of the allowed port range")
    private int maximumPort = 65535;
    @Option(name="--zookeeper-ticktime", multiValued=false, description="The length of a single tick, which is the basic time unit used by ZooKeeper, as measured in milliseconds. It is used to regulate heartbeats, and timeouts. For example, the minimum session timeout will be two ticks")
    private int zooKeeperTickTime = 2000;
    @Option(name="--zookeeper-init-limit", multiValued=false, description="The amount of time, in ticks (see tickTime), to allow followers to connect and sync to a leader")
    private int zooKeeperInitLimit = 10;
    @Option(name="--zookeeper-sync-limit", multiValued=false, description="The amount of time, in ticks (see tickTime), to allow followers to sync with ZooKeeper")
    private int zooKeeperSyncLimit = 5;
    @Option(name="--zookeeper-data-dir", multiValued=false, description="The location where ZooKeeper will store the in-memory database snapshots and, unless specified otherwise, the transaction log of updates to the database.")
    private String zooKeeperDataDir = "data/zookeeper";
    @Option(name="--zookeeper-password", multiValued=false, description="The ensemble password to use (one will be generated if not given)")
    private String zookeeperPassword;
    @Option(name="--zookeeper-server-port", multiValued=false, description="The main port for ZooKeeper server")
    private int zooKeeperServerPort = -1;
    @Option(name="--generate-zookeeper-password", multiValued=false, description="Flag to enable automatic generation of password")
    private boolean generateZookeeperPassword = false;
    @Option(name="--new-user", multiValued=false, description="The username of a new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUser;
    @Option(name="--new-user-password", multiValued=false, description="The password of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserPassword;
    @Option(name="--external-git-url", multiValued=false, description="Specify an external git url.")
    private String externalGitUrl;
    @Option(name="--external-git-user", multiValued=false, description="Specify an external git user.")
    private String externalGitUser;
    @Option(name="--external-git-passowrd", multiValued=false, description="Specify an external git password.")
    private String externalGitPassword;
    @Option(name="--new-user-role", multiValued=false, description="The role of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserRole = "admin";
    @Argument(required=false, multiValued=true, description="List of containers. Empty list assumes current container only.")
    private List<String> containers;
    private static final String ROLE_DELIMITER = ",";
    private final BundleContext bundleContext;
    private final ZooKeeperClusterBootstrap bootstrap;
    private final RuntimeProperties runtimeProperties;

    CreateAction(BundleContext bundleContext, ZooKeeperClusterBootstrap bootstrap, RuntimeProperties runtimeProperties) {
        this.bundleContext = bundleContext;
        this.bootstrap = bootstrap;
        this.runtimeProperties = runtimeProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        String karafName = this.runtimeProperties.getProperty("karaf.name");
        CreateEnsembleOptions.Builder builder = CreateEnsembleOptions.builder().zooKeeperServerTickTime(this.zooKeeperTickTime).zooKeeperServerInitLimit(this.zooKeeperInitLimit).zooKeeperServerSyncLimit(this.zooKeeperSyncLimit).zooKeeperServerDataDir(this.zooKeeperDataDir).fromRuntimeProperties((RuntimeProperties)new DefaultRuntimeProperties()).bootstrapTimeout(this.bootstrapTimeout).waitForProvision(this.waitForProvisioning).clean(this.clean);
        builder.version(this.version);
        if (this.containers == null || this.containers.isEmpty()) {
            this.containers = Arrays.asList(karafName);
        }
        if (!this.noImport && this.importDir != null) {
            builder.autoImportEnabled(true);
            builder.importPath(this.importDir);
        }
        if (this.globalResolver != null) {
            builder.globalResolver(this.globalResolver);
            System.setProperty("global.resolver", this.globalResolver);
        }
        if (this.resolver != null) {
            builder.resolver(this.resolver);
            System.setProperty("local.resolver", this.resolver);
        }
        if (this.manualIp != null) {
            builder.manualIp(this.manualIp);
            System.setProperty("manualip", this.manualIp);
        }
        if (this.bindAddress != null) {
            if (!this.bindAddress.contains(":")) {
                builder.bindAddress(this.bindAddress);
                System.setProperty("bind.address", this.bindAddress);
            } else {
                String[] parts = this.bindAddress.split(":");
                builder.bindAddress(parts[0]);
                builder.zooKeeperServerPort(Integer.parseInt(parts[1]));
                System.setProperty("bind.address", parts[0]);
            }
        }
        if (this.zooKeeperServerPort > 0) {
            builder.setZooKeeperServerPort(this.zooKeeperServerPort);
            builder.setZooKeeperServerConnectionPort(this.zooKeeperServerPort);
        }
        if (this.externalGitUrl != null) {
            builder.dataStoreProperty(GIT_EXTERNAL_URL, this.externalGitUrl);
        }
        if (this.externalGitUser != null) {
            builder.dataStoreProperty(GIT_REMOTE_USER, this.externalGitUser);
        }
        if (this.externalGitPassword != null) {
            builder.dataStoreProperty(GIT_REMOTE_PASSWORD, this.externalGitPassword);
        }
        if (this.profiles != null && this.profiles.size() > 0) {
            builder.profiles(this.profiles);
        }
        if (this.nonManaged) {
            builder.agentEnabled(false);
        } else {
            builder.agentEnabled(true);
        }
        builder.minimumPort(this.minimumPort);
        builder.minimumPort(this.maximumPort);
        System.setProperty("minimum.port", String.valueOf(this.minimumPort));
        System.setProperty("maximum.port", String.valueOf(this.maximumPort));
        this.newUser = this.newUser != null ? this.newUser : ShellUtils.retrieveFabricUser(this.session);
        this.newUserPassword = this.newUserPassword != null ? this.newUserPassword : ShellUtils.retrieveFabricUserPassword(this.session);
        Properties userProps = new Properties(new File(System.getProperty("karaf.home") + "/etc/users.properties"));
        if (userProps.isEmpty()) {
            String[] credentials = this.promptForNewUser(this.newUser, this.newUserPassword);
            this.newUser = credentials[0];
            this.newUserPassword = credentials[1];
        } else if (this.newUser == null || this.newUserPassword == null) {
            String[] passwardAndRoles;
            this.newUser = "" + (String)userProps.keySet().iterator().next();
            this.newUserPassword = "" + (String)userProps.get(this.newUser);
            if (this.newUserPassword.contains(ROLE_DELIMITER) && (passwardAndRoles = this.newUserPassword.split("\\,", 2)).length >= 2) {
                this.newUserPassword = passwardAndRoles[0].trim();
                this.newUserRole = passwardAndRoles[1].trim();
            }
        }
        if (Strings.isNullOrEmpty((String)this.newUser)) {
            System.out.println("No user specified. Cannot create a new fabric ensemble.");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.session != null) {
            ShellUtils.storeFabricCredentials(this.session, this.newUser, this.newUserPassword);
        }
        if (!this.generateZookeeperPassword) {
            if (this.zookeeperPassword == null) {
                this.zookeeperPassword = PasswordEncoder.decode(System.getProperty("zookeeper.password", PasswordEncoder.encode(this.newUserPassword)));
                builder.zookeeperPassword(this.zookeeperPassword);
            } else {
                builder.zookeeperPassword(this.zookeeperPassword);
            }
        }
        CreateEnsembleOptions options = builder.users((Map)userProps).withUser(this.newUser, this.newUserPassword, this.newUserRole).build();
        if (this.containers.size() == 1 && this.containers.contains(karafName)) {
            this.bootstrap.create(options);
        } else {
            ServiceProxy serviceProxy = ServiceProxy.createServiceProxy((BundleContext)this.bundleContext, ZooKeeperClusterService.class);
            try {
                ((ZooKeeperClusterService)serviceProxy.getService()).createCluster(this.containers, options);
            }
            finally {
                serviceProxy.close();
            }
        }
        ShellUtils.storeZookeeperPassword(this.session, options.getZookeeperPassword());
        if (this.zookeeperPassword == null && !this.generateZookeeperPassword) {
            sb.append("Zookeeper password: (reusing users ").append(this.newUser).append(" password:").append(options.getZookeeperPassword()).append(")\n");
            sb.append("(You can use the --zookeeper-password / --generate-zookeeper-password option to specify one.)\n");
        } else if (this.generateZookeeperPassword) {
            sb.append("Generated zookeeper password:").append(options.getZookeeperPassword());
        }
        System.out.println(sb.toString());
        if (!this.nonManaged && !this.waitForProvisioning) {
            System.out.println("It may take a couple of seconds for the container to provision...");
            System.out.println("You can use the --wait-for-provisioning option, if you want this command to block until the container is provisioned.");
        }
        return null;
    }

    private String[] promptForNewUser(String user, String password) throws IOException {
        String[] response = new String[2];
        if (user == null || password == null) {
            System.out.println("No user found in etc/users.properties or specified as an option. Please specify one ...");
        }
        while ((user == null || user.isEmpty()) && (user = ShellUtils.readLine(this.session, "New user name: ", false)) != null) {
        }
        if (user != null && password == null) {
            String password1 = null;
            String password2 = null;
            while (password1 == null || !password1.equals(password2)) {
                password1 = ShellUtils.readLine(this.session, "Password for " + user + ": ", true);
                password2 = ShellUtils.readLine(this.session, "Verify password for " + user + ":", true);
                if (password1 == null || password2 == null) break;
                if (password1 != null && password1.equals(password2)) {
                    password = password1;
                    continue;
                }
                System.out.println("Passwords did not match. Please try again!");
            }
        }
        response[0] = user;
        response[1] = password;
        return response;
    }

    private static String getDefaultImportDir() {
        return System.getProperty("karaf.home", ".") + File.separatorChar + "fabric" + File.separatorChar + "import";
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public boolean isNoImport() {
        return this.noImport;
    }

    public void setNoImport(boolean noImport) {
        this.noImport = noImport;
    }

    public String getImportDir() {
        return this.importDir;
    }

    public void setImportDir(String importDir) {
        this.importDir = importDir;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public long getEnsembleStartupTime() {
        return this.ensembleStartupTime;
    }

    public void setEnsembleStartupTime(long ensembleStartupTime) {
        this.ensembleStartupTime = ensembleStartupTime;
    }

    public List<String> getContainers() {
        return this.containers;
    }

    public void setContainers(List<String> containers) {
        this.containers = containers;
    }

    public int getMinimumPort() {
        return this.minimumPort;
    }

    public void setMinimumPort(int minimumPort) {
        this.minimumPort = minimumPort;
    }

    public int getMaximumPort() {
        return this.maximumPort;
    }

    public void setMaximumPort(int maximumPort) {
        this.maximumPort = maximumPort;
    }

    public String getZookeeperPassword() {
        return this.zookeeperPassword;
    }

    public void setZookeeperPassword(String zookeeperPassword) {
        this.zookeeperPassword = zookeeperPassword;
    }

    public String getNewUser() {
        return this.newUser;
    }

    public void setNewUser(String newUser) {
        this.newUser = newUser;
    }

    public String getNewUserPassword() {
        return this.newUserPassword;
    }

    public void setNewUserPassword(String newUserPassword) {
        this.newUserPassword = newUserPassword;
    }

    public String getNewUserRole() {
        return this.newUserRole;
    }

    public void setNewUserRole(String newUserRole) {
        this.newUserRole = newUserRole;
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = profiles;
    }

    public boolean isNonManaged() {
        return this.nonManaged;
    }

    public void setNonManaged(boolean nonManaged) {
        this.nonManaged = nonManaged;
    }

    public String getGlobalResolver() {
        return this.globalResolver;
    }

    public void setGlobalResolver(String globalResolver) {
        this.globalResolver = globalResolver;
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public String getManualIp() {
        return this.manualIp;
    }

    public void setManualIp(String manualIp) {
        this.manualIp = manualIp;
    }

    public boolean isGenerateZookeeperPassword() {
        return this.generateZookeeperPassword;
    }

    public void setGenerateZookeeperPassword(boolean generateZookeeperPassword) {
        this.generateZookeeperPassword = generateZookeeperPassword;
    }
}

