/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.AbstractDownloadTask;
import io.fabric8.agent.download.DownloadManagerHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDownloadTask
extends AbstractDownloadTask {
    private static final String BLUEPRINT_PREFIX = "blueprint:";
    private static final String SPRING_PREFIX = "spring:";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDownloadTask.class);
    private static final String Ix2 = "  ";
    private static final String Ix4 = "    ";

    public SimpleDownloadTask(String url, ExecutorService executor) {
        super(url, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File download() throws Exception {
        LOG.trace("Downloading [" + this.url + "]");
        if (this.url.startsWith(BLUEPRINT_PREFIX) || this.url.startsWith(SPRING_PREFIX)) {
            return this.downloadBlueprintOrSpring();
        }
        try {
            URL urlObj = new URL(this.url);
            File file = new File(this.getFileName(urlObj.getFile()));
            if (file.exists()) {
                return file;
            }
            File dir = new File(System.getProperty("karaf.data"), "fabric-agent");
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new IOException("Unable to create directory " + dir.toString());
            }
            File tmpFile = File.createTempFile("download-", null, dir);
            InputStream is = urlObj.openStream();
            try {
                FileOutputStream os = new FileOutputStream(tmpFile);
                try {
                    SimpleDownloadTask.copy(is, os);
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                is.close();
            }
            if (file.exists() && !file.delete()) {
                throw new IOException("Unable to delete file: " + file.toString());
            }
            if (!tmpFile.renameTo(file)) {
                throw new IOException("Unable to rename file " + tmpFile.toString() + " to " + file.toString());
            }
            return file;
        }
        catch (IOException ignore) {
            LOG.debug("  Could not download [" + this.url + "]");
            LOG.trace("  Reason [" + ignore.getClass().getName() + ": " + ignore.getMessage() + "]");
            throw new IOException("URL [" + this.url + "] could not be resolved.");
        }
    }

    private String getFileName(String url) {
        url = DownloadManagerHelper.stripUrl(url);
        int unixPos = url.lastIndexOf(47);
        int windowsPos = url.lastIndexOf(92);
        return url.substring(Math.max(unixPos, windowsPos) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadBlueprintOrSpring() throws Exception {
        File dir = new File(System.getProperty("karaf.data"), "fabric-agent");
        dir.mkdirs();
        File tmpFile = File.createTempFile("download-", null, dir);
        InputStream is = new URL(this.url).openStream();
        try {
            FileOutputStream os = new FileOutputStream(tmpFile);
            try {
                SimpleDownloadTask.copy(is, os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            is.close();
        }
        return tmpFile;
    }
}

