/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fusesource.insight.log.service.support.MavenCoordinates;
import org.fusesource.insight.log.storage.InsightUtils;
import org.fusesource.insight.storage.StorageService;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightLogAppender
implements PaxAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsightLogAppender.class);
    private String name;
    private String type;
    private StorageService storage;

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStorage(StorageService storage) {
        this.storage = storage;
    }

    public void doAppend(PaxLoggingEvent paxLoggingEvent) {
        try {
            if ("TRACE".equals(paxLoggingEvent.getLevel().toString().toUpperCase()) && !paxLoggingEvent.getProperties().containsKey("trace-id")) {
                return;
            }
            StringBuilder writer = new StringBuilder();
            writer.append("{ \"host\" : ");
            InsightUtils.quote(this.name, writer);
            writer.append(",\n  \"timestamp\" : ");
            InsightUtils.quote(InsightUtils.formatDate(paxLoggingEvent.getTimeStamp()), writer);
            writer.append(",\n  \"level\" : ");
            InsightUtils.quote(paxLoggingEvent.getLevel().toString(), writer);
            writer.append(",\n  \"logger\" : ");
            InsightUtils.quote(paxLoggingEvent.getLoggerName(), writer);
            writer.append(",\n  \"thread\" : ");
            InsightUtils.quote(paxLoggingEvent.getThreadName(), writer);
            writer.append(",\n  \"message\" : ");
            InsightUtils.quote(paxLoggingEvent.getMessage(), writer);
            String[] throwable = paxLoggingEvent.getThrowableStrRep();
            if (throwable != null) {
                throwable = MavenCoordinates.addMavenCoord(throwable);
                writer.append(",\n  \"exception\" : [");
                for (int i = 0; i < throwable.length; ++i) {
                    if (i != 0) {
                        writer.append(", ");
                    }
                    InsightUtils.quote(throwable[i], writer);
                }
                writer.append("]");
            }
            writer.append(",\n  \"properties\" : { ");
            boolean first = true;
            HashMap<String, String> properties = new HashMap<String, String>();
            Set set = paxLoggingEvent.getProperties().entrySet();
            for (Map.Entry entry : set) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                properties.put(key.toString(), value.toString());
            }
            MavenCoordinates.addMavenCoord(properties);
            for (Map.Entry key : properties.keySet()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(", ");
                }
                InsightUtils.quote(key.toString(), writer);
                writer.append(": ");
                InsightUtils.quote(((String)properties.get(key)).toString(), writer);
            }
            writer.append(" }");
            writer.append("\n}");
            this.storage.store(this.type, paxLoggingEvent.getTimeStamp(), writer.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Error appending log to storage", (Throwable)e);
        }
    }
}

