/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefFilter;

public class TransferConfig {
    public static final Config.SectionParser<TransferConfig> KEY = new Config.SectionParser<TransferConfig>(){

        @Override
        public TransferConfig parse(Config cfg) {
            return new TransferConfig(cfg);
        }
    };
    private final boolean fsckObjects;
    private final boolean allowTipSha1InWant;
    private final String[] hideRefs;

    TransferConfig(Repository db) {
        this(db.getConfig());
    }

    private TransferConfig(Config rc) {
        this.fsckObjects = rc.getBoolean("receive", "fsckobjects", false);
        this.allowTipSha1InWant = rc.getBoolean("uploadpack", "allowtipsha1inwant", false);
        this.hideRefs = rc.getStringList("uploadpack", null, "hiderefs");
    }

    public boolean isFsckObjects() {
        return this.fsckObjects;
    }

    public boolean isAllowTipSha1InWant() {
        return this.allowTipSha1InWant;
    }

    public RefFilter getRefFilter() {
        if (this.hideRefs.length == 0) {
            return RefFilter.DEFAULT;
        }
        return new RefFilter(){

            @Override
            public Map<String, Ref> filter(Map<String, Ref> refs) {
                HashMap<String, Ref> result = new HashMap<String, Ref>();
                for (Map.Entry<String, Ref> e : refs.entrySet()) {
                    boolean add = true;
                    for (String hide : TransferConfig.this.hideRefs) {
                        if (!e.getKey().equals(hide) && !this.prefixMatch(hide, e.getKey())) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    result.put(e.getKey(), e.getValue());
                }
                return result;
            }

            private boolean prefixMatch(String p, String s) {
                return p.charAt(p.length() - 1) == '/' && s.startsWith(p);
            }
        };
    }
}

