/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterStateRequest
extends MasterNodeOperationRequest<ClusterStateRequest> {
    private boolean filterRoutingTable = false;
    private boolean filterNodes = false;
    private boolean filterMetaData = false;
    private boolean filterBlocks = false;
    private String[] filteredIndices = Strings.EMPTY_ARRAY;
    private String[] filteredIndexTemplates = Strings.EMPTY_ARRAY;
    private boolean local = false;

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public ClusterStateRequest filterAll() {
        this.filterRoutingTable = true;
        this.filterNodes = true;
        this.filterMetaData = true;
        this.filterBlocks = true;
        this.filteredIndices = Strings.EMPTY_ARRAY;
        this.filteredIndexTemplates = Strings.EMPTY_ARRAY;
        return this;
    }

    public boolean filterRoutingTable() {
        return this.filterRoutingTable;
    }

    public ClusterStateRequest filterRoutingTable(boolean filterRoutingTable) {
        this.filterRoutingTable = filterRoutingTable;
        return this;
    }

    public boolean filterNodes() {
        return this.filterNodes;
    }

    public ClusterStateRequest filterNodes(boolean filterNodes) {
        this.filterNodes = filterNodes;
        return this;
    }

    public boolean filterMetaData() {
        return this.filterMetaData;
    }

    public ClusterStateRequest filterMetaData(boolean filterMetaData) {
        this.filterMetaData = filterMetaData;
        return this;
    }

    public boolean filterBlocks() {
        return this.filterBlocks;
    }

    public ClusterStateRequest filterBlocks(boolean filterBlocks) {
        this.filterBlocks = filterBlocks;
        return this;
    }

    public String[] filteredIndices() {
        return this.filteredIndices;
    }

    public ClusterStateRequest filteredIndices(String ... filteredIndices) {
        this.filteredIndices = filteredIndices;
        return this;
    }

    public String[] filteredIndexTemplates() {
        return this.filteredIndexTemplates;
    }

    public ClusterStateRequest filteredIndexTemplates(String ... filteredIndexTemplates) {
        this.filteredIndexTemplates = filteredIndexTemplates;
        return this;
    }

    public ClusterStateRequest local(boolean local) {
        this.local = local;
        return this;
    }

    public boolean local() {
        return this.local;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.filterRoutingTable = in.readBoolean();
        this.filterNodes = in.readBoolean();
        this.filterMetaData = in.readBoolean();
        this.filterBlocks = in.readBoolean();
        this.filteredIndices = in.readStringArray();
        this.filteredIndexTemplates = in.readStringArray();
        this.local = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.filterRoutingTable);
        out.writeBoolean(this.filterNodes);
        out.writeBoolean(this.filterMetaData);
        out.writeBoolean(this.filterBlocks);
        out.writeStringArray(this.filteredIndices);
        out.writeStringArray(this.filteredIndexTemplates);
        out.writeBoolean(this.local);
    }
}

