/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteMappingRequest
extends MasterNodeOperationRequest<DeleteMappingRequest> {
    private String[] indices;
    private String mappingType;

    DeleteMappingRequest() {
    }

    public DeleteMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.mappingType == null) {
            validationException = ValidateActions.addValidationError("mapping type is missing", validationException);
        }
        return validationException;
    }

    public DeleteMappingRequest indices(String[] indices) {
        this.indices = indices;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public String type() {
        return this.mappingType;
    }

    public DeleteMappingRequest type(String mappingType) {
        this.mappingType = mappingType;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readString();
        }
        if (in.readBoolean()) {
            this.mappingType = in.readString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indices.length);
            for (String index : this.indices) {
                out.writeString(index);
            }
        }
        if (this.mappingType == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.mappingType);
        }
    }
}

