/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy;

import java.io.IOException;
import org.elasticsearch.common.compress.BufferRecycler;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.snappy.SnappyCompressor;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class SnappyCompressedStreamOutput
extends CompressedStreamOutput<SnappyCompressorContext> {
    protected final BufferRecycler recycler = BufferRecycler.instance();
    protected byte[] compressedBuffer;

    public SnappyCompressedStreamOutput(StreamOutput out, SnappyCompressorContext context) throws IOException {
        super(out, context);
        this.uncompressed = this.recycler.allocOutputBuffer(context.compressChunkLength());
        this.uncompressedLength = context.compressChunkLength();
        this.compressedBuffer = this.recycler.allocEncodingBuffer(context.compressMaxCompressedChunkLength());
    }

    @Override
    public void writeHeader(StreamOutput out) throws IOException {
        out.writeBytes(SnappyCompressor.HEADER);
        out.writeVInt(((SnappyCompressorContext)this.context).compressChunkLength());
        out.writeVInt(((SnappyCompressorContext)this.context).compressMaxCompressedChunkLength());
    }

    @Override
    protected void doClose() throws IOException {
        byte[] buf = this.uncompressed;
        if (buf != null) {
            this.uncompressed = null;
            this.recycler.releaseOutputBuffer(buf);
        }
        if ((buf = this.compressedBuffer) != null) {
            this.compressedBuffer = null;
            this.recycler.releaseEncodeBuffer(buf);
        }
    }
}

