/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy.xerial;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.compress.snappy.SnappyCompressedIndexOutput;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.xerial.snappy.Snappy;

public class XerialSnappyCompressedIndexOutput
extends SnappyCompressedIndexOutput {
    public XerialSnappyCompressedIndexOutput(IndexOutput out, SnappyCompressorContext context) throws IOException {
        super(out, context);
    }

    @Override
    protected void compress(byte[] data, int offset, int len, IndexOutput out) throws IOException {
        int compressedLength = Snappy.rawCompress((Object)data, (int)offset, (int)len, (byte[])this.compressedBuffer, (int)0);
        if (compressedLength >= len - len / 8) {
            out.writeByte((byte)0);
            out.writeVInt(len);
            out.writeBytes(data, offset, len);
        } else {
            out.writeByte((byte)1);
            out.writeVInt(compressedLength);
            out.writeBytes(this.compressedBuffer, 0, compressedLength);
        }
    }
}

