/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.unit.TimeValue;

public class TransportRequestOptions {
    public static final TransportRequestOptions EMPTY = TransportRequestOptions.options();
    private TimeValue timeout;
    private boolean compress;
    private Type type = Type.MED;

    public static TransportRequestOptions options() {
        return new TransportRequestOptions();
    }

    public TransportRequestOptions withTimeout(long timeout) {
        return this.withTimeout(TimeValue.timeValueMillis(timeout));
    }

    public TransportRequestOptions withTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public TransportRequestOptions withCompress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public TransportRequestOptions withType(Type type) {
        this.type = type;
        return this;
    }

    public TransportRequestOptions withHighType() {
        this.type = Type.HIGH;
        return this;
    }

    public TransportRequestOptions withMedType() {
        this.type = Type.MED;
        return this;
    }

    public TransportRequestOptions withLowType() {
        this.type = Type.LOW;
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public boolean compress() {
        return this.compress;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        LOW,
        MED,
        HIGH;


        public static Type fromString(String type) {
            if ("low".equalsIgnoreCase(type)) {
                return LOW;
            }
            if ("med".equalsIgnoreCase(type)) {
                return MED;
            }
            if ("high".equalsIgnoreCase(type)) {
                return HIGH;
            }
            throw new ElasticSearchIllegalArgumentException("failed to match transport type for [" + type + "]");
        }
    }
}

