/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.osgi.framework.Bundle;

public class ExtenderContext {
    private final ConcurrentHashMap<Bundle, HttpServiceTracker> httpServiceTrackers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ContextKey, WebApplication> webApplications = new ConcurrentHashMap();

    public WebApplication getWebApplication(Bundle bundle, String httpContextId) {
        if (bundle == null) {
            return null;
        }
        ContextKey contextKey = new ContextKey(bundle, httpContextId);
        WebApplication webApplication = this.webApplications.get(contextKey);
        if (webApplication == null) {
            webApplication = new WebApplication(bundle, httpContextId);
            WebApplication existingWebApplication = this.webApplications.putIfAbsent(contextKey, webApplication);
            if (existingWebApplication == null) {
                webApplication.start();
            } else {
                webApplication = existingWebApplication;
            }
        }
        return webApplication;
    }

    public WebApplication getExistingWebApplication(Bundle bundle, String httpContextId) {
        if (bundle == null) {
            return null;
        }
        ContextKey contextKey = new ContextKey(bundle, httpContextId);
        return this.webApplications.get(contextKey);
    }

    public void removeWebApplication(WebApplication webApplication) {
        ContextKey contextKey = new ContextKey(webApplication.getBundle(), webApplication.getHttpContextId());
        this.webApplications.remove(contextKey);
        webApplication.stop();
    }

    private static class ContextKey {
        Bundle bundle;
        String httpContextId;

        private ContextKey(Bundle bundle, String httpContextId) {
            this.bundle = bundle;
            this.httpContextId = httpContextId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextKey that = (ContextKey)o;
            if (this.bundle != null ? !this.bundle.equals(that.bundle) : that.bundle != null) {
                return false;
            }
            return !(this.httpContextId != null ? !this.httpContextId.equals(that.httpContextId) : that.httpContextId != null);
        }

        public int hashCode() {
            int result = this.bundle != null ? this.bundle.hashCode() : 0;
            result = 31 * result + (this.httpContextId != null ? this.httpContextId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("bundle=").append(this.bundle).append(",httpContextId=").append(this.httpContextId).append("}").toString();
        }
    }
}

