/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.commands;

import io.fabric8.zookeeper.commands.ZooKeeperCommandSupport;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="list", scope="zk", description="List a znode's children", detailedDescription="classpath:list.txt")
public class List
extends ZooKeeperCommandSupport {
    @Argument(description="Path of the znode to list")
    String path = "/";
    @Option(name="-r", aliases={"--recursive"}, description="List children recursively")
    boolean recursive = false;
    @Option(name="-d", aliases={"--display"}, description="Display a znode's value if set")
    boolean display = false;

    @Override
    protected void doExecute(CuratorFramework zk) throws Exception {
        this.display(zk, this.path);
    }

    private java.util.List<String> getPaths(CuratorFramework zk) throws Exception {
        if (this.recursive) {
            return ZooKeeperUtils.getAllChildren((CuratorFramework)zk, (String)this.path);
        }
        return ZooKeeperUtils.getChildren((CuratorFramework)zk, (String)this.path);
    }

    protected void display(CuratorFramework curator, String path) throws Exception {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        java.util.List<String> paths = this.getPaths(curator);
        for (String p : paths) {
            if (this.display) {
                byte[] data = (byte[])curator.getData().forPath(this.recursive ? p : path + p);
                if (data != null) {
                    System.out.printf("%s = %s\n", p, new String(data));
                    continue;
                }
                System.out.println(p);
                continue;
            }
            System.out.println(p);
        }
    }
}

