/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.compress.BufferRecycler;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.snappy.SnappyCompressor;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.elasticsearch.common.io.stream.StreamInput;

public abstract class SnappyCompressedStreamInput
extends CompressedStreamInput<SnappyCompressorContext> {
    protected final BufferRecycler recycler = BufferRecycler.instance();
    protected int chunkSize;
    protected int maxCompressedChunkLength;
    protected byte[] inputBuffer;

    public SnappyCompressedStreamInput(StreamInput in, SnappyCompressorContext context) throws IOException {
        super(in, context);
        this.uncompressed = this.recycler.allocDecodeBuffer(Math.max(this.chunkSize, this.maxCompressedChunkLength));
        this.inputBuffer = this.recycler.allocInputBuffer(Math.max(this.chunkSize, this.maxCompressedChunkLength));
    }

    @Override
    public void readHeader(StreamInput in) throws IOException {
        byte[] header = new byte[SnappyCompressor.HEADER.length];
        in.readBytes(header, 0, header.length);
        if (!Arrays.equals(header, SnappyCompressor.HEADER)) {
            throw new IOException("wrong snappy compressed header [" + Arrays.toString(header) + "]");
        }
        this.chunkSize = in.readVInt();
        this.maxCompressedChunkLength = in.readVInt();
    }

    @Override
    protected void doClose() throws IOException {
        byte[] buf = this.uncompressed;
        if (buf != null) {
            this.uncompressed = null;
            this.recycler.releaseDecodeBuffer(this.uncompressed);
        }
        if ((buf = this.inputBuffer) != null) {
            this.inputBuffer = null;
            this.recycler.releaseInputBuffer(this.inputBuffer);
        }
    }
}

