/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericLongAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class LongFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "long";
    private Long nullValue;
    private String nullValueAsString;

    protected LongFieldMapper(FieldMapper.Names names, int precisionStep, String fuzzyFactor, Field.Index index, Field.Store store, float boost, boolean omitNorms, FieldInfo.IndexOptions indexOptions, Long nullValue, Explicit<Boolean> ignoreMalformed) {
        super(names, precisionStep, fuzzyFactor, index, store, boost, omitNorms, indexOptions, ignoreMalformed, new NamedAnalyzer("_long/" + precisionStep, new NumericLongAnalyzer(precisionStep)), new NamedAnalyzer("_long/max", new NumericLongAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return Numbers.bytesToLong(value);
    }

    @Override
    public Long valueFromString(String value) {
        return Long.valueOf(value);
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.longToPrefixCoded(Long.parseLong(value));
    }

    @Override
    public Query fuzzyQuery(String value, String minSim, int prefixLength, int maxExpansions) {
        long iSim;
        long iValue = Long.parseLong(value);
        try {
            iSim = Long.parseLong(minSim);
        }
        catch (NumberFormatException e) {
            iSim = (long)Double.parseDouble(minSim);
        }
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query fuzzyQuery(String value, double minSim, int prefixLength, int maxExpansions) {
        long iValue = Long.parseLong(value);
        long iSim = (long)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query fieldQuery(String value, @Nullable QueryParseContext context) {
        long iValue = Long.parseLong(value);
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, iValue, iValue, true, true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Long.valueOf(Long.parseLong(lowerTerm)), upperTerm == null ? null : Long.valueOf(Long.parseLong(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter fieldFilter(String value, @Nullable QueryParseContext context) {
        long iValue = Long.parseLong(value);
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, iValue, iValue, true, true);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Long.valueOf(Long.parseLong(lowerTerm)), upperTerm == null ? null : Long.valueOf(Long.parseLong(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newLongRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Long.valueOf(Long.parseLong(lowerTerm)), upperTerm == null ? null : Long.valueOf(Long.parseLong(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, this.nullValue, this.nullValue, true, true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected Fieldable innerParseCreateField(ParseContext context) throws IOException {
        long value;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return null;
                }
                value = this.nullValue;
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.nullValue == null) {
                        return null;
                    }
                    value = this.nullValue;
                } else {
                    value = Long.parseLong(sExternalValue);
                }
            } else {
                value = ((Number)externalValue).longValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.names.fullName(), Long.toString(value), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.nullValue == null) {
                    return null;
                }
                value = this.nullValue;
                if (this.nullValueAsString != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), this.nullValueAsString, boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                Long objValue = this.nullValue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = parser.longValue();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return null;
                }
                value = objValue;
            } else {
                value = parser.longValue();
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), parser.text(), boost);
                }
            }
        }
        CustomLongNumericField field = new CustomLongNumericField((NumberFieldMapper)this, value);
        field.setBoost(boost);
        return field;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.LONG;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((LongFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((LongFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (this.indexOptions != Defaults.INDEX_OPTIONS) {
            builder.field("index_options", LongFieldMapper.indexOptionToString(this.indexOptions));
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.fuzzyFactor != Defaults.FUZZY_FACTOR) {
            builder.field("fuzzy_factor", this.fuzzyFactor);
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class CustomLongNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final long number;
        private final NumberFieldMapper mapper;

        public CustomLongNumericField(NumberFieldMapper mapper, long number) {
            super(mapper, mapper.stored() ? Numbers.longToBytes(number) : null);
            this.mapper = mapper;
            this.number = number;
        }

        @Override
        public TokenStream tokenStreamValue() {
            if (this.isIndexed) {
                return this.mapper.popCachedStream().setLongValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Long.toString(this.number);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.longField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeLongValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, LongFieldMapper> {
        protected Long nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder nullValue(long nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public LongFieldMapper build(Mapper.BuilderContext context) {
            LongFieldMapper fieldMapper = new LongFieldMapper(this.buildNames(context), this.precisionStep, this.fuzzyFactor, this.index, this.store, this.boost, this.omitNorms, this.indexOptions, this.nullValue, this.ignoreMalformed(context));
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final Long NULL_VALUE = null;
    }
}

