/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import io.fabric8.agent.resolver.BaseClause;
import io.fabric8.agent.resolver.CapabilitySet;
import io.fabric8.agent.resolver.SimpleFilter;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class RequirementImpl
extends BaseClause
implements Requirement {
    private final Resource m_resource;
    private final String m_namespace;
    private final SimpleFilter m_filter;
    private final boolean m_optional;
    private final Map<String, String> m_dirs;
    private final Map<String, Object> m_attrs;

    public RequirementImpl(Resource resource, String namespace, Map<String, String> dirs, Map<String, Object> attrs, SimpleFilter filter) {
        this.m_resource = resource;
        this.m_namespace = namespace;
        this.m_dirs = dirs;
        this.m_attrs = attrs;
        this.m_filter = filter;
        this.m_optional = "optional".equals(this.m_dirs.get("resolution"));
    }

    public RequirementImpl(Resource resource, String namespace, Map<String, String> dirs, Map<String, Object> attrs) {
        this(resource, namespace, dirs, attrs, SimpleFilter.convert(attrs));
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.m_dirs;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.m_attrs;
    }

    @Override
    public Resource getResource() {
        return this.m_resource;
    }

    public boolean matches(Capability cap) {
        return CapabilitySet.matches(cap, this.getFilter());
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public SimpleFilter getFilter() {
        return this.m_filter;
    }
}

