/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.bnd.make.MakeBnd;
import aQute.bnd.make.MakeCopy;
import aQute.bnd.make.component.ServiceComponent;
import aQute.bnd.make.metatype.MetatypePlugin;
import aQute.bnd.maven.PomParser;
import aQute.bnd.service.Plugin;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Macro;
import aQute.lib.osgi.Verifier;
import aQute.libg.generics.Create;
import aQute.libg.header.OSGiHeader;
import aQute.libg.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processor
implements Reporter,
Constants,
Closeable {
    public static String DEFAULT_PLUGINS = "";
    public static String LIST_SPLITTER = "\\\\?\\s*,\\s*";
    static Executor executor;
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();
    boolean pedantic;
    boolean trace;
    boolean exceptions;
    boolean fileMustExist = true;
    List<Object> plugins;
    private File base = new File("").getAbsoluteFile();
    private List<Closeable> toBeClosed = this.newList();
    Properties properties;
    private Macro replacer;
    private long lastModified;
    private File propertiesFile;
    private boolean fixup = true;
    long modified;
    Processor parent;
    Set<File> included;
    CL pluginLoader;
    Collection<String> filter;
    HashSet<String> missingCommand;
    List<Object> basicPlugins = new ArrayList<Object>();

    public Processor() {
        this.properties = new Properties();
    }

    public Processor(Properties parent) {
        this.properties = new Properties(parent);
    }

    public Processor(Processor parent) {
        this(parent.properties);
        this.parent = parent;
    }

    public void setParent(Processor processor) {
        this.parent = processor;
        Properties ext = new Properties(processor.properties);
        ext.putAll((Map<?, ?>)this.properties);
        this.properties = ext;
    }

    public Processor getParent() {
        return this.parent;
    }

    public Processor getTop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getTop();
    }

    public void getInfo(Processor processor, String prefix) {
        if (this.isFailOk()) {
            this.addAll(this.warnings, processor.getErrors(), prefix);
        } else {
            this.addAll(this.errors, processor.getErrors(), prefix);
        }
        this.addAll(this.warnings, processor.getWarnings(), prefix);
        processor.errors.clear();
        processor.warnings.clear();
    }

    public void getInfo(Processor processor) {
        this.getInfo(processor, "");
    }

    private <T> void addAll(List<String> to, List<? extends T> from, String prefix) {
        for (T x : from) {
            to.add(prefix + x);
        }
    }

    @Override
    public void warning(String string, Object ... args) {
        String s = String.format(string, args);
        if (!this.warnings.contains(s)) {
            this.warnings.add(s);
        }
    }

    @Override
    public void error(String string, Object ... args) {
        if (this.isFailOk()) {
            this.warning(string, args);
        } else {
            String s = String.format(string, args);
            if (!this.errors.contains(s)) {
                this.errors.add(s);
            }
        }
    }

    public void error(String string, Throwable t, Object ... args) {
        if (this.isFailOk()) {
            this.warning(string + ": " + t, args);
        } else {
            this.errors.add("Exception: " + t.getMessage());
            String s = String.format(string, args);
            if (!this.errors.contains(s)) {
                this.errors.add(s);
            }
        }
        if (this.exceptions) {
            t.printStackTrace();
        }
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public Map<String, Map<String, String>> parseHeader(String value) {
        return Processor.parseHeader(value, this);
    }

    public static Map<String, Map<String, String>> parseHeader(String value, Processor logger) {
        return OSGiHeader.parseHeader(value, logger);
    }

    Map<String, Map<String, String>> getClauses(String header) {
        return this.parseHeader(this.getProperty(header));
    }

    public void addClose(Closeable jar) {
        this.toBeClosed.add(jar);
    }

    static <T> Map<String, T> removeKeys(Map<String, T> source, String prefix) {
        TreeMap<String, T> temp = new TreeMap<String, T>(source);
        Iterator p = temp.keySet().iterator();
        while (p.hasNext()) {
            String pack = (String)p.next();
            if (!pack.startsWith(prefix)) continue;
            p.remove();
        }
        return temp;
    }

    @Override
    public void progress(String s, Object ... args) {
    }

    @Override
    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public static File getFile(File base, String file) {
        int n;
        File f = new File(file);
        if (f.isAbsolute()) {
            return f;
        }
        f = base.getAbsoluteFile();
        while ((n = file.indexOf(47)) > 0) {
            String first = file.substring(0, n);
            file = file.substring(n + 1);
            if (first.equals("..")) {
                f = f.getParentFile();
                continue;
            }
            f = new File(f, first);
        }
        if (file.equals("..")) {
            return f.getParentFile();
        }
        return new File(f, file).getAbsoluteFile();
    }

    public File getFile(String file) {
        return Processor.getFile(this.base, file);
    }

    public <T> List<T> getPlugins(Class<T> clazz) {
        ArrayList<T> l = new ArrayList<T>();
        List<Object> all = this.getPlugins();
        for (Object plugin : all) {
            if (!clazz.isInstance(plugin)) continue;
            l.add(clazz.cast(plugin));
        }
        return l;
    }

    protected synchronized List<Object> getPlugins() {
        if (this.plugins != null) {
            return this.plugins;
        }
        this.missingCommand = new HashSet();
        String spe = this.getProperty("-plugin", DEFAULT_PLUGINS);
        Map<String, Map<String, String>> plugins = this.parseHeader(spe);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new MakeBnd());
        list.add(new MakeCopy());
        list.add(new ServiceComponent());
        list.add(new MetatypePlugin());
        list.addAll(this.basicPlugins);
        for (Map.Entry<String, Map<String, String>> entry : plugins.entrySet()) {
            String key = entry.getKey();
            if (key.equals("none")) {
                this.plugins = this.newList();
                return this.plugins;
            }
            try {
                CL loader = this.getLoader();
                String path = entry.getValue().get("path:");
                if (path != null) {
                    String[] parts;
                    for (String p : parts = path.split("\\s*,\\s*")) {
                        File f = this.getFile(p).getAbsoluteFile();
                        loader.add(f.toURI().toURL());
                    }
                }
                this.trace("Using plugin %s", key);
                key = Processor.removeDuplicateMarker(key);
                try {
                    Class<?> c = loader.loadClass(key);
                    Object plugin = c.newInstance();
                    if (plugin instanceof Plugin) {
                        ((Plugin)plugin).setProperties(entry.getValue());
                        ((Plugin)plugin).setReporter(this);
                    }
                    list.add(plugin);
                }
                catch (Throwable t) {
                    String commands = entry.getValue().get("command:");
                    if (commands == null) {
                        this.error("Problem loading the plugin: %s exception: (%s)", key, t);
                        continue;
                    }
                    Collection<String> cs = Processor.split(commands);
                    this.missingCommand.addAll(cs);
                }
            }
            catch (Throwable e) {
                this.error("Problem loading the plugin: " + key + " exception: " + e, new Object[0]);
            }
        }
        this.plugins = list;
        return this.plugins;
    }

    public boolean isFailOk() {
        String v = this.getProperty("-failok", null);
        return v != null && v.equalsIgnoreCase("true");
    }

    public File getBase() {
        return this.base;
    }

    public void setBase(File base) {
        this.base = base;
    }

    public void clear() {
        this.errors.clear();
        this.warnings.clear();
    }

    @Override
    public void trace(String msg, Object ... parms) {
        if (this.trace) {
            System.out.printf("# " + msg + "\n", parms);
        }
    }

    public <T> List<T> newList() {
        return new ArrayList();
    }

    public <T> Set<T> newSet() {
        return new TreeSet();
    }

    public static <K, V> Map<K, V> newMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public <T> List<T> newList(Collection<T> t) {
        return new ArrayList<T>(t);
    }

    public <T> Set<T> newSet(Collection<T> t) {
        return new TreeSet<T>(t);
    }

    public <K, V> Map<K, V> newMap(Map<K, V> t) {
        return new LinkedHashMap<K, V>(t);
    }

    @Override
    public void close() {
        for (Closeable c : this.toBeClosed) {
            try {
                c.close();
            }
            catch (IOException iOException) {}
        }
        this.toBeClosed = null;
    }

    public String _basedir(String[] args) {
        if (this.base == null) {
            throw new IllegalArgumentException("No base dir set");
        }
        return this.base.getAbsolutePath();
    }

    public Properties getProperties() {
        if (this.fixup) {
            this.fixup = false;
            this.begin();
        }
        return this.properties;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public void mergeProperties(File file, boolean override) {
        if (file.isFile()) {
            try {
                Properties properties = this.loadProperties(file);
                this.mergeProperties(properties, override);
            }
            catch (Exception e) {
                this.error("Error loading properties file: " + file, new Object[0]);
            }
        } else if (!file.exists()) {
            this.error("Properties file does not exist: " + file, new Object[0]);
        } else {
            this.error("Properties file must a file, not a directory: " + file, new Object[0]);
        }
    }

    public void mergeProperties(Properties properties, boolean override) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            if (!override && this.getProperties().containsKey(key)) continue;
            this.setProperty(key, value);
        }
    }

    public void setProperties(Properties properties) {
        this.doIncludes(this.getBase(), properties);
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void addProperties(File file) throws Exception {
        this.addIncluded(file);
        Properties p = this.loadProperties(file);
        this.setProperties(p);
    }

    public synchronized void addIncluded(File file) {
        if (this.included == null) {
            this.included = new HashSet<File>();
        }
        this.included.add(file);
    }

    private void doIncludes(File ubase, Properties p) {
        String includes = p.getProperty("-include");
        if (includes != null) {
            includes = this.getReplacer().process(includes);
            p.remove("-include");
            Set<String> clauses = this.parseHeader(includes).keySet();
            for (String value : clauses) {
                boolean fileMustExist = true;
                boolean overwrite = true;
                while (true) {
                    if (value.startsWith("-")) {
                        fileMustExist = false;
                        value = value.substring(1).trim();
                        continue;
                    }
                    if (!value.startsWith("~")) break;
                    overwrite = false;
                    value = value.substring(1).trim();
                }
                try {
                    File file = Processor.getFile(ubase, value).getAbsoluteFile();
                    if (!file.isFile() && fileMustExist) {
                        this.error("Included file " + file + (file.exists() ? " does not exist" : " is directory"), new Object[0]);
                        continue;
                    }
                    this.doIncludeFile(file, overwrite, p);
                }
                catch (Exception e) {
                    if (!fileMustExist) continue;
                    this.error("Error in processing included file: " + value, e, new Object[0]);
                }
            }
        }
    }

    public void doIncludeFile(File file, boolean overwrite, Properties target) throws Exception {
        if (this.included != null && this.included.contains(file)) {
            this.error("Cyclic or multiple include of " + file, new Object[0]);
        } else {
            this.addIncluded(file);
            this.updateModified(file.lastModified(), file.toString());
            FileInputStream in = new FileInputStream(file);
            Properties sub = file.getName().toLowerCase().endsWith(".mf") ? Processor.getManifestAsProperties(in) : (file.getName().endsWith(".xml") ? this.parseXml(file) : this.loadProperties(in, file.getAbsolutePath()));
            ((InputStream)in).close();
            this.doIncludes(file.getParentFile(), sub);
            for (Map.Entry<Object, Object> entry : sub.entrySet()) {
                if (!overwrite && target.containsKey(entry.getKey())) continue;
                target.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseXml(File file) throws Exception {
        PomParser pp = new PomParser();
        try {
            Properties properties = pp.getProperties(file);
            return properties;
        }
        finally {
            this.getInfo(pp);
        }
    }

    public void unsetProperty(String string) {
        this.getProperties().remove(string);
    }

    public boolean refresh() {
        this.plugins = null;
        if (this.propertiesFile == null) {
            return false;
        }
        this.updateModified(this.propertiesFile.lastModified(), "properties file");
        boolean changed = false;
        if (this.included != null) {
            for (File file : this.included) {
                if (file.exists() && file.lastModified() <= this.modified) continue;
                this.updateModified(file.lastModified(), "include file: " + file);
                changed = true;
            }
        }
        if (changed |= this.modified < this.propertiesFile.lastModified()) {
            this.included = null;
            this.properties.clear();
            this.setProperties(this.propertiesFile, this.base);
            this.propertiesChanged();
            return true;
        }
        return false;
    }

    public void propertiesChanged() {
    }

    public void setProperties(File propertiesFile) throws IOException {
        propertiesFile = propertiesFile.getAbsoluteFile();
        this.setProperties(propertiesFile, propertiesFile.getParentFile());
    }

    public void setProperties(File propertiesFile, File base) {
        this.propertiesFile = propertiesFile.getAbsoluteFile();
        this.setBase(base);
        try {
            if (propertiesFile.isFile()) {
                long modified = propertiesFile.lastModified();
                if (modified > System.currentTimeMillis() + 100L) {
                    System.out.println("Huh? This is in the future " + propertiesFile);
                    this.modified = System.currentTimeMillis();
                } else {
                    this.modified = modified;
                }
                this.included = null;
                Properties p = this.loadProperties(propertiesFile);
                this.setProperties(p);
            } else if (this.fileMustExist) {
                this.error("No such properties file: " + propertiesFile, new Object[0]);
            }
        }
        catch (IOException e) {
            this.error("Could not load properties " + propertiesFile, new Object[0]);
        }
    }

    protected void begin() {
        if (Processor.isTrue(this.getProperty("-pedantic"))) {
            this.setPedantic(true);
        }
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        return !"false".equalsIgnoreCase(value);
    }

    public String getProperty(String key, String deflt) {
        Processor source;
        String value = null;
        if (this.filter != null && this.filter.contains(key)) {
            value = (String)this.getProperties().get(key);
        } else {
            for (source = this; source != null && (value = (String)source.getProperties().get(key)) == null; source = source.getParent()) {
            }
        }
        if (value != null) {
            return this.getReplacer().process(value, source);
        }
        if (deflt != null) {
            return this.getReplacer().process(deflt, this);
        }
        return null;
    }

    public Properties loadProperties(File file) throws IOException {
        this.updateModified(file.lastModified(), "Properties file: " + file);
        FileInputStream in = new FileInputStream(file);
        Properties p = this.loadProperties(in, file.getAbsolutePath());
        ((InputStream)in).close();
        return p;
    }

    Properties loadProperties(InputStream in, String name) throws IOException {
        int n = name.lastIndexOf(47);
        if (n > 0) {
            name = name.substring(0, n);
        }
        if (name.length() == 0) {
            name = ".";
        }
        try {
            Properties p = new Properties();
            p.load(in);
            return Processor.replaceAll(p, "\\$\\{\\.\\}", name);
        }
        catch (Exception e) {
            this.error("Error during loading properties file: " + name + ", error:" + e, new Object[0]);
            return new Properties();
        }
    }

    public static Properties replaceAll(Properties p, String pattern, String replacement) {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = value.replaceAll(pattern, replacement);
            result.put(key, value);
        }
        return result;
    }

    public static Map<String, Map<String, String>> merge(String type, Map<String, Map<String, String>> instructions, Map<String, Map<String, String>> actual, Set<String> superfluous, Map<String, Map<String, String>> ignored) {
        HashMap<String, Map<String, String>> toVisit = new HashMap<String, Map<String, String>>(actual);
        Map<String, Map<String, String>> result = Processor.newMap();
        Iterator<String> i = instructions.keySet().iterator();
        while (i.hasNext()) {
            String instruction;
            String originalInstruction = instruction = i.next();
            Map<String, String> instructedAttributes = instructions.get(instruction);
            if (instruction.startsWith("=")) {
                result.put(instruction.substring(1), instructedAttributes);
                superfluous.remove(originalInstruction);
                continue;
            }
            if (Processor.isDuplicate(instruction)) {
                result.put(instruction, instructedAttributes);
                superfluous.remove(originalInstruction);
                continue;
            }
            Instruction instr = Instruction.getPattern(instruction);
            Iterator p = toVisit.keySet().iterator();
            while (p.hasNext()) {
                String packageName = (String)p.next();
                if (!instr.matches(packageName)) continue;
                superfluous.remove(originalInstruction);
                if (!instr.isNegated()) {
                    HashMap<String, String> newAttributes = new HashMap<String, String>();
                    newAttributes.putAll(actual.get(packageName));
                    newAttributes.putAll(instructedAttributes);
                    result.put(packageName, newAttributes);
                } else if (ignored != null) {
                    ignored.put(packageName, new HashMap());
                }
                p.remove();
            }
        }
        return result;
    }

    public static String printClauses(Map<String, Map<String, String>> exports, String allowedDirectives) {
        return Processor.printClauses(exports, allowedDirectives, false);
    }

    public static String printClauses(Map<String, Map<String, String>> exports, String allowedDirectives, boolean checkMultipleVersions) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (String name : exports.keySet()) {
            Map<String, String> clause = exports.get(name);
            String outname = Processor.removeDuplicateMarker(name);
            sb.append(del);
            sb.append(outname);
            Processor.printClause(clause, allowedDirectives, sb);
            del = ",";
        }
        return sb.toString();
    }

    public static void printClause(Map<String, String> map, String allowedDirectives, StringBuffer sb) {
        for (String key : map.keySet()) {
            boolean clean;
            if (!key.startsWith("x-") && key.endsWith(":") && (allowedDirectives == null || allowedDirectives.indexOf(key) < 0)) continue;
            String value = map.get(key).trim();
            sb.append(";");
            sb.append(key);
            sb.append("=");
            boolean bl = clean = value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' || Verifier.TOKEN.matcher(value).matches();
            if (!clean) {
                sb.append("\"");
            }
            sb.append(value);
            if (clean) continue;
            sb.append("\"");
        }
    }

    public Macro getReplacer() {
        if (this.replacer == null) {
            this.replacer = new Macro(this, this.getMacroDomains());
            return this.replacer;
        }
        return this.replacer;
    }

    protected Object[] getMacroDomains() {
        return new Object[0];
    }

    public Properties getFlattenedProperties() {
        return this.getReplacer().getFlattenedProperties();
    }

    public void updateModified(long time, String reason) {
        if (time > this.lastModified) {
            this.lastModified = time;
        }
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setProperty(String key, String value) {
        for (int i = 0; i < headers.length; ++i) {
            if (!headers[i].equalsIgnoreCase(value)) continue;
            value = headers[i];
            break;
        }
        this.getProperties().put(key, value);
    }

    public static Properties getManifestAsProperties(InputStream in) throws IOException {
        Properties p = new Properties();
        Manifest manifest = new Manifest(in);
        for (Attributes.Name name : manifest.getMainAttributes().keySet()) {
            String value = manifest.getMainAttributes().getValue(name);
            p.put(name.toString(), value);
        }
        return p;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setFileMustExist(boolean mustexist) {
        this.fileMustExist = mustexist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in) throws Exception {
        InputStreamReader ir = new InputStreamReader(in, "UTF8");
        StringBuilder sb = new StringBuilder();
        try {
            char[] chars = new char[1000];
            int size = ir.read(chars);
            while (size > 0) {
                sb.append(chars, 0, size);
                size = ir.read(chars);
            }
        }
        finally {
            ir.close();
        }
        return sb.toString();
    }

    public static String join(Collection<?> list, String delimeter) {
        return Processor.join(delimeter, list);
    }

    public static String join(String delimeter, Collection<?> ... list) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Collection<?> l : list) {
            if (list == null) continue;
            for (Object item : l) {
                sb.append(del);
                sb.append(item);
                del = delimeter;
            }
        }
        return sb.toString();
    }

    public static String join(Object[] list, String delimeter) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Object item : list) {
            sb.append(del);
            sb.append(item);
            del = delimeter;
        }
        return sb.toString();
    }

    public static String join(Collection<?> ... list) {
        return Processor.join(",", list);
    }

    public static <T> String join(T[] list) {
        return Processor.join(list, ",");
    }

    public static void split(String s, Collection<String> set) {
        String[] elements;
        for (String element : elements = s.trim().split(LIST_SPLITTER)) {
            if (element.length() <= 0) continue;
            set.add(element);
        }
    }

    public static Collection<String> split(String s) {
        return Processor.split(s, LIST_SPLITTER);
    }

    public static Collection<String> split(String s, String splitter) {
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.trim().length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(s.split(splitter));
    }

    public static String merge(String ... strings) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : strings) {
            if (s == null) continue;
            Processor.split(s, result);
        }
        return Processor.join(result);
    }

    public boolean isExceptions() {
        return this.exceptions;
    }

    public void setExceptions(boolean exceptions) {
        this.exceptions = exceptions;
    }

    public String normalize(String f) {
        if (f.startsWith(this.base.getAbsolutePath() + "/")) {
            return f.substring(this.base.getAbsolutePath().length() + 1);
        }
        return f;
    }

    public String normalize(File f) {
        return this.normalize(f.getAbsolutePath());
    }

    public static String removeDuplicateMarker(String key) {
        int i;
        for (i = key.length() - 1; i >= 0 && key.charAt(i) == '~'; --i) {
        }
        return key.substring(0, i + 1);
    }

    public static boolean isDuplicate(String name) {
        return name.length() > 0 && name.charAt(name.length() - 1) == '~';
    }

    public void setTrace(boolean x) {
        this.trace = x;
    }

    private CL getLoader() {
        if (this.pluginLoader == null) {
            this.pluginLoader = new CL();
        }
        return this.pluginLoader;
    }

    public boolean exists() {
        return this.base != null && this.base.isDirectory() && this.propertiesFile != null && this.propertiesFile.isFile();
    }

    public boolean isOk() {
        return this.isFailOk() || this.getErrors().size() == 0;
    }

    public boolean isPerfect() {
        return this.getErrors().size() == 0 && this.getWarnings().size() == 0;
    }

    public void setForceLocal(Collection<String> local) {
        this.filter = local;
    }

    public boolean isMissingPlugin(String name) {
        this.getPlugins();
        return this.missingCommand != null && this.missingCommand.contains(name);
    }

    public static String appendPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        boolean lastSlash = true;
        for (String part : parts) {
            for (int i = 0; i < part.length(); ++i) {
                char c = part.charAt(i);
                if (c == '/') {
                    if (!lastSlash) {
                        sb.append('/');
                    }
                    lastSlash = true;
                    continue;
                }
                sb.append(c);
                lastSlash = false;
            }
            if (!(!lastSlash & sb.length() > 0)) continue;
            sb.append('/');
            lastSlash = true;
        }
        if (lastSlash && sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Map<String, String> doAttrbutes(Object[] attrs, Clazz clazz, Macro macro) {
        if (attrs == null || attrs.length == 0) {
            return Collections.emptyMap();
        }
        Map<String, String> map = Processor.newMap();
        for (Object a : attrs) {
            String attr = (String)a;
            int n = attr.indexOf("=");
            if (n <= 0) {
                throw new IllegalArgumentException(String.format("Invalid attribute on package-info.java in %s , %s. Must be <key>=<name> ", clazz, attr));
            }
            map.put(attr.substring(0, n), macro.process(attr.substring(n + 1)));
        }
        return map;
    }

    public static String append(String ... strings) {
        List result = Create.list();
        for (String s : strings) {
            result.addAll(Processor.split(s));
        }
        return Processor.join(result);
    }

    public synchronized void addBasicPlugin(Object o) {
        this.basicPlugins.add(o);
        if (this.plugins != null) {
            this.plugins.add(o);
        }
    }

    public synchronized void removeBasicPlugin(Object o) {
        this.basicPlugins.remove(o);
        if (this.plugins != null) {
            this.plugins.remove(o);
        }
    }

    public synchronized Class<?> getClass(String type, File jar) throws Exception {
        CL cl = this.getLoader();
        cl.add(jar.toURI().toURL());
        return cl.loadClass(type);
    }

    public static void delete(File target) {
        if (target.getParentFile() == null) {
            throw new IllegalArgumentException("Can not delete root!");
        }
        if (!target.exists()) {
            return;
        }
        if (target.isDirectory()) {
            File[] sub;
            for (File s : sub = target.listFiles()) {
                Processor.delete(s);
            }
        }
        target.delete();
    }

    public boolean isTrace() {
        return this.trace;
    }

    public static Executor getExecutor() {
        if (executor == null) {
            executor = Executors.newCachedThreadPool();
        }
        return executor;
    }

    public static long getDuration(String tm, long dflt) {
        if (tm == null) {
            return dflt;
        }
        tm = tm.toUpperCase();
        TimeUnit unit = TimeUnit.MILLISECONDS;
        Matcher m = Pattern.compile("\\s*(\\d+)\\s*(NANOSECONDS|MICROSECONDS|MILLISECONDS|SECONDS|MINUTES|HOURS|DAYS)?").matcher(tm);
        if (m.matches()) {
            long duration = Long.parseLong(tm);
            String u = m.group(2);
            if (u != null) {
                unit = TimeUnit.valueOf(u);
            }
            duration = TimeUnit.MILLISECONDS.convert(duration, unit);
            return duration;
        }
        return dflt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CL
    extends URLClassLoader {
        CL() {
            super(new URL[0], Processor.class.getClassLoader());
        }

        void add(URL url) {
            URL[] urls;
            for (URL u : urls = this.getURLs()) {
                if (!u.equals(url)) continue;
                return;
            }
            super.addURL(url);
        }

        @Override
        public Class<?> loadClass(String name) throws NoClassDefFoundError {
            try {
                Class<?> c = super.loadClass(name);
                return c;
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder();
                sb.append(name);
                sb.append(" not found, parent:  ");
                sb.append(this.getParent());
                sb.append(" urls:");
                sb.append(Arrays.toString(this.getURLs()));
                sb.append(" exception:");
                sb.append(t);
                throw new NoClassDefFoundError(sb.toString());
            }
        }
    }
}

