/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.resolver;

import io.fabric8.agent.resolver.BaseClause;
import io.fabric8.agent.resolver.ResourceBuilder;
import io.fabric8.agent.resolver.SimpleFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class CapabilityImpl
extends BaseClause
implements Capability {
    private final Resource m_resource;
    private final String m_namespace;
    private final Map<String, String> m_dirs;
    private final Map<String, Object> m_attrs;
    private final List<String> m_uses;
    private final List<List<String>> m_includeFilter;
    private final List<List<String>> m_excludeFilter;
    private final Set<String> m_mandatory;

    public CapabilityImpl(Capability capability) {
        this(null, capability.getNamespace(), capability.getDirectives(), capability.getAttributes());
    }

    public CapabilityImpl(Resource resource, String namespace, Map<String, String> dirs, Map<String, Object> attrs) {
        List<String> substrings;
        List<String> filters;
        this.m_namespace = namespace;
        this.m_resource = resource;
        this.m_dirs = dirs;
        this.m_attrs = attrs;
        List uses = Collections.emptyList();
        String value = this.m_dirs.get("uses");
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, ",");
            uses = new ArrayList(tok.countTokens());
            while (tok.hasMoreTokens()) {
                uses.add(tok.nextToken().trim());
            }
        }
        this.m_uses = uses;
        value = this.m_dirs.get("include");
        if (value != null) {
            filters = ResourceBuilder.parseDelimitedString(value, ",");
            this.m_includeFilter = new ArrayList<List<String>>(filters.size());
            for (String filter : filters) {
                substrings = SimpleFilter.parseSubstring(filter);
                this.m_includeFilter.add(substrings);
            }
        } else {
            this.m_includeFilter = null;
        }
        if ((value = this.m_dirs.get("exclude")) != null) {
            filters = ResourceBuilder.parseDelimitedString(value, ",");
            this.m_excludeFilter = new ArrayList<List<String>>(filters.size());
            for (String filter : filters) {
                substrings = SimpleFilter.parseSubstring(filter);
                this.m_excludeFilter.add(substrings);
            }
        } else {
            this.m_excludeFilter = null;
        }
        Set mandatory = Collections.emptySet();
        value = this.m_dirs.get("mandatory");
        if (value != null) {
            List<String> names = ResourceBuilder.parseDelimitedString(value, ",");
            mandatory = new HashSet(names.size());
            for (String name : names) {
                if (this.m_attrs.containsKey(name)) {
                    mandatory.add(name);
                    continue;
                }
                throw new IllegalArgumentException("Mandatory attribute '" + name + "' does not exist.");
            }
        }
        this.m_mandatory = mandatory;
    }

    @Override
    public Resource getResource() {
        return this.m_resource;
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.m_dirs;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.m_attrs;
    }

    public boolean isAttributeMandatory(String name) {
        return !this.m_mandatory.isEmpty() && this.m_mandatory.contains(name);
    }

    public List<String> getUses() {
        return this.m_uses;
    }

    public boolean isIncluded(String name) {
        if (this.m_includeFilter == null && this.m_excludeFilter == null) {
            return true;
        }
        String className = CapabilityImpl.getClassName(name);
        boolean included = this.m_includeFilter == null;
        for (int i = 0; !included && this.m_includeFilter != null && i < this.m_includeFilter.size(); ++i) {
            included = SimpleFilter.compareSubstring(this.m_includeFilter.get(i), className);
        }
        boolean excluded = false;
        for (int i = 0; !excluded && this.m_excludeFilter != null && i < this.m_excludeFilter.size(); ++i) {
            excluded = SimpleFilter.compareSubstring(this.m_excludeFilter.get(i), className);
        }
        return included && !excluded;
    }

    private static String getClassName(String className) {
        if (className == null) {
            className = "";
        }
        return className.lastIndexOf(46) < 0 ? "" : className.substring(className.lastIndexOf(46) + 1);
    }
}

