/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.client.HostProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StaticHostProvider
implements HostProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHostProvider.class);
    private final List<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>(5);
    private int lastIndex = -1;
    private int currentIndex = -1;

    public StaticHostProvider(Collection<InetSocketAddress> serverAddresses) {
        for (InetSocketAddress address : serverAddresses) {
            try {
                InetAddress[] resolvedAddresses;
                InetAddress ia = address.getAddress();
                for (InetAddress resolvedAddress : resolvedAddresses = InetAddress.getAllByName(ia != null ? ia.getHostAddress() : address.getHostName())) {
                    if (resolvedAddress.toString().startsWith("/") && resolvedAddress.getAddress() != null) {
                        this.serverAddresses.add(new InetSocketAddress(InetAddress.getByAddress(address.getHostName(), resolvedAddress.getAddress()), address.getPort()));
                        continue;
                    }
                    this.serverAddresses.add(new InetSocketAddress(resolvedAddress.getHostAddress(), address.getPort()));
                }
            }
            catch (UnknownHostException e) {
                LOG.error("Unable to connect to server: {}", (Object)address, (Object)e);
            }
        }
        if (this.serverAddresses.isEmpty()) {
            throw new IllegalArgumentException("A HostProvider may not be empty!");
        }
        Collections.shuffle(this.serverAddresses);
    }

    @Override
    public int size() {
        return this.serverAddresses.size();
    }

    @Override
    public InetSocketAddress next(long spinDelay) {
        ++this.currentIndex;
        if (this.currentIndex == this.serverAddresses.size()) {
            this.currentIndex = 0;
        }
        if (this.currentIndex == this.lastIndex && spinDelay > 0L) {
            try {
                Thread.sleep(spinDelay);
            }
            catch (InterruptedException e) {
                LOG.warn("Unexpected exception", (Throwable)e);
            }
        } else if (this.lastIndex == -1) {
            this.lastIndex = 0;
        }
        return this.serverAddresses.get(this.currentIndex);
    }

    @Override
    public void onConnected() {
        this.lastIndex = this.currentIndex;
    }
}

