/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.dosgi.util;

import io.fabric8.dosgi.util.internal.BundleToClassLoaderAdapter;
import io.fabric8.dosgi.util.internal.DefaultWorker;
import io.fabric8.dosgi.util.internal.EquinoxWorker;
import io.fabric8.dosgi.util.internal.FelixWorker;
import io.fabric8.dosgi.util.internal.FrameworkUtilWorker;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class AriesFrameworkUtil {
    private static final FrameworkUtilWorker WORKER;

    public static ClassLoader getClassLoader(Bundle b) {
        if (b.getState() != 1 && b.getState() != 2) {
            return WORKER.getClassLoader(b);
        }
        return null;
    }

    private static boolean isEquinox(String bundleClassName) {
        if (bundleClassName != null && bundleClassName.startsWith("org.eclipse.equinox")) {
            try {
                Class.forName("org.eclipse.osgi.framework.internal.core.BundleHost");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isFelix(String bundleClassName) {
        return bundleClassName != null && bundleClassName.startsWith("org.apache.felix");
    }

    static {
        FrameworkUtilWorker w = null;
        Bundle b = FrameworkUtil.getBundle(AriesFrameworkUtil.class);
        if (b == null) {
            w = new FrameworkUtilWorker(){

                @Override
                public ClassLoader getClassLoader(final Bundle b) {
                    return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            return new BundleToClassLoaderAdapter(b);
                        }
                    });
                }

                @Override
                public boolean isValid() {
                    return true;
                }
            };
        } else {
            String bundleClassName = b.getClass().getName();
            if (AriesFrameworkUtil.isEquinox(bundleClassName)) {
                w = new EquinoxWorker();
            } else if (AriesFrameworkUtil.isFelix(bundleClassName)) {
                w = new FelixWorker();
            }
            if (w == null || !w.isValid()) {
                w = new DefaultWorker();
            }
        }
        WORKER = w;
    }
}

