/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.internal.ProfileOverlayImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfileImpl
implements Profile {
    private final String id;
    private final String version;
    private final FabricService fabricService;

    public ProfileImpl(String id, String version, FabricService service) {
        this.id = id;
        this.version = version;
        this.fabricService = service;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getAttributes() {
        return this.fabricService.getDataStore().getProfileAttributes(this.version, this.id);
    }

    public void setAttribute(String key, String value) {
        this.fabricService.getDataStore().setProfileAttribute(this.version, this.id, key, value);
    }

    public int compareTo(Profile profile) {
        return this.id.compareTo(profile.getId());
    }

    public List<String> getLibraries() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.LIBRARIES);
    }

    public List<String> getEndorsedLibraries() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.ENDORSED);
    }

    public List<String> getExtensionLibraries() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.EXTENSION);
    }

    public List<String> getBundles() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.BUNDLES);
    }

    public List<String> getFabs() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.FABS);
    }

    public List<String> getFeatures() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.FEATURES);
    }

    public List<String> getRepositories() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.REPOSITORIES);
    }

    public List<String> getOverrides() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.OVERRIDES);
    }

    public void setBundles(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.BUNDLES);
    }

    public void setFabs(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.FABS);
    }

    public void setFeatures(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.FEATURES);
    }

    public void setRepositories(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.REPOSITORIES);
    }

    public void setOverrides(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.OVERRIDES);
    }

    public static List<String> getContainerConfigList(Profile p, ConfigListType type) {
        try {
            Map containerProps = p.getContainerConfiguration();
            ArrayList<String> rc = new ArrayList<String>();
            String prefix = (Object)((Object)type) + ".";
            for (Map.Entry e : containerProps.entrySet()) {
                if (!((String)e.getKey()).startsWith(prefix)) continue;
                rc.add((String)e.getValue());
            }
            return rc;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public static void setContainerConfigList(Profile p, List<String> values, ConfigListType type) {
        Map config = p.getConfigurations();
        String prefix = (Object)((Object)type) + ".";
        HashMap<String, String> map = (HashMap<String, String>)config.get("io.fabric8.agent");
        if (map == null) {
            map = new HashMap<String, String>();
            config.put("io.fabric8.agent", map);
        } else {
            ArrayList keys = new ArrayList(map.keySet());
            for (String key : keys) {
                if (!key.startsWith(prefix)) continue;
                map.remove(key);
            }
        }
        for (String value : values) {
            map.put(prefix + value, value);
        }
        p.setConfigurations(config);
    }

    public Profile[] getParents() {
        try {
            String str = this.getAttributes().get("parents");
            if (str == null || str.isEmpty()) {
                return new Profile[0];
            }
            str = str.trim();
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            Version v = this.fabricService.getVersion(this.version);
            for (String p : str.split("\\s+")) {
                profiles.add(v.getProfile(p));
            }
            return profiles.toArray(new Profile[profiles.size()]);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setParents(Profile[] parents) {
        if (parents == null) {
            this.setAttribute("parents", null);
            return;
        }
        this.assertNotLocked();
        try {
            StringBuilder sb = new StringBuilder();
            for (Profile parent : parents) {
                if (!this.version.equals(parent.getVersion())) {
                    throw new IllegalArgumentException("Version mismatch setting parent profile " + parent + " with version " + parent.getVersion() + " expected version " + this.version);
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(parent.getId());
            }
            this.setAttribute("parents", sb.toString());
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public Container[] getAssociatedContainers() {
        try {
            Container[] containers;
            ArrayList<Container> rc = new ArrayList<Container>();
            block2: for (Container container : containers = this.fabricService.getContainers()) {
                if (!container.getVersion().getId().equals(this.getVersion())) continue;
                for (Profile p : container.getProfiles()) {
                    if (!this.equals(p)) continue;
                    rc.add(container);
                    continue block2;
                }
            }
            return rc.toArray(new Container[0]);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public boolean isOverlay() {
        return false;
    }

    public Profile getOverlay() {
        return new ProfileOverlayImpl(this, this.fabricService.getEnvironment());
    }

    public Profile getOverlay(boolean substitute) {
        return new ProfileOverlayImpl(this, this.fabricService.getEnvironment(), substitute, this.fabricService);
    }

    public Map<String, byte[]> getFileConfigurations() {
        return this.fabricService.getDataStore().getFileConfigurations(this.version, this.id);
    }

    public List<String> getConfigurationFileNames() {
        return this.fabricService.getDataStore().getConfigurationFileNames(this.version, this.id);
    }

    public byte[] getFileConfiguration(String fileName) {
        return this.fabricService.getDataStore().getFileConfiguration(this.version, this.id, fileName);
    }

    public void setFileConfigurations(Map<String, byte[]> configurations) {
        this.assertNotLocked();
        this.fabricService.getDataStore().setFileConfigurations(this.version, this.id, configurations);
    }

    public Map<String, Map<String, String>> getConfigurations() {
        return this.fabricService.getDataStore().getConfigurations(this.version, this.id);
    }

    public Map<String, String> getConfiguration(String pid) {
        return this.fabricService.getDataStore().getConfiguration(this.version, this.id, pid);
    }

    public Map<String, String> getContainerConfiguration() {
        Map<String, String> map = this.getConfigurations().get("io.fabric8.agent");
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public void setConfigurations(Map<String, Map<String, String>> configurations) {
        this.assertNotLocked();
        this.fabricService.getDataStore().setConfigurations(this.version, this.id, configurations);
    }

    public void setConfiguration(String pid, Map<String, String> configuration) {
        this.assertNotLocked();
        this.fabricService.getDataStore().setConfiguration(this.version, this.id, pid, configuration);
    }

    public void refresh() {
        Map<String, Map<String, String>> configuration = this.getConfigurations();
        Map<String, String> agentConfiguration = configuration.get("io.fabric8.agent");
        if (agentConfiguration == null) {
            agentConfiguration = new HashMap<String, String>();
        }
        agentConfiguration.put("lastRefresh." + this.id, String.valueOf(System.currentTimeMillis()));
        this.setConfigurations(configuration);
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean force) {
        Container[] containers = this.getAssociatedContainers();
        if (containers.length == 0) {
            this.fabricService.getDataStore().deleteProfile(this.version, this.id);
        } else if (force) {
            for (Container container : containers) {
                container.removeProfiles(new Profile[]{this});
            }
            this.fabricService.getDataStore().deleteProfile(this.version, this.id);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot delete profile:").append(this.id).append(".");
            sb.append("Profile has assigned ").append(containers.length).append(" container(s):");
            for (Container c : containers) {
                sb.append(" ").append(c.getId());
            }
            sb.append(". Use force option to also remove the profile from the containers.");
            throw new FabricException(sb.toString());
        }
        FabricRequirements requirements = this.fabricService.getRequirements();
        if (requirements.removeProfileRequirements(this.id)) {
            try {
                this.fabricService.setRequirements(requirements);
            }
            catch (IOException e) {
                throw new FabricException("Failed to update requirements after deleting profile " + this.id + ". " + e, (Throwable)e);
            }
        }
    }

    public boolean configurationEquals(Profile other) {
        Object[] parents = this.getParents();
        Object[] otherParents = other.getParents();
        Arrays.sort(parents);
        Arrays.sort(otherParents);
        if (!this.getConfigurations().equals(other.getConfigurations())) {
            return false;
        }
        if (parents.length != otherParents.length) {
            return false;
        }
        for (int i = 0; i < parents.length; ++i) {
            if (parents[i].configurationEquals((Profile)otherParents[i])) continue;
            return false;
        }
        return true;
    }

    public boolean agentConfigurationEquals(Profile other) {
        ProfileOverlayImpl selfOverlay = new ProfileOverlayImpl(this, this.fabricService.getEnvironment());
        return selfOverlay.agentConfigurationEquals(other);
    }

    public boolean exists() {
        return this.fabricService.getVersion(this.version).hasProfile(this.id);
    }

    public String toString() {
        return "ProfileImpl[id='" + this.id + '\'' + ", version='" + this.version + '\'' + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileImpl profile = (ProfileImpl)o;
        if (!this.id.equals(profile.id)) {
            return false;
        }
        return this.version.equals(profile.version);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean isAbstract() {
        return Boolean.parseBoolean(this.getAttributes().get("abstract"));
    }

    public boolean isLocked() {
        return Boolean.parseBoolean(this.getAttributes().get("locked"));
    }

    public boolean isHidden() {
        return Boolean.parseBoolean(this.getAttributes().get("hidden"));
    }

    public String getProfileHash() {
        return this.fabricService.getDataStore().getLastModified(this.version, this.id);
    }

    protected void assertNotLocked() {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("The profile " + this.id + " is locked and can not be modified");
        }
    }

    public static enum ConfigListType {
        LIBRARIES("lib"),
        ENDORSED("endorsed"),
        EXTENSION("extension"),
        BUNDLES("bundle"),
        FABS("fab"),
        FEATURES("feature"),
        REPOSITORIES("repository"),
        OVERRIDES("override");

        private String value;

        private ConfigListType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

