/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class FileResource
implements Resource {
    File file;
    String extra;

    public FileResource(File file) {
        this.file = file;
    }

    public InputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    public static void build(Jar jar, File directory, Pattern doNotCopy) {
        FileResource.traverse(jar, directory.getAbsolutePath().length(), directory, doNotCopy);
    }

    public String toString() {
        return ":" + this.file.getName() + ":";
    }

    public void write(OutputStream out) throws Exception {
        FileResource.copy(this, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void copy(Resource resource, OutputStream out) throws Exception {
        InputStream in = resource.openInputStream();
        try {
            byte[] buffer = new byte[20000];
            int size = in.read(buffer);
            while (size > 0) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
        }
        finally {
            in.close();
        }
    }

    static void traverse(Jar jar, int rootlength, File directory, Pattern doNotCopy) {
        if (doNotCopy != null && doNotCopy.matcher(directory.getName()).matches()) {
            return;
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileResource.traverse(jar, rootlength, files[i], doNotCopy);
                continue;
            }
            String path = files[i].getAbsolutePath().substring(rootlength + 1);
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            jar.putResource(path, new FileResource(files[i]), true);
        }
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public long size() {
        return (int)this.file.length();
    }
}

