/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.bootstrap;

import io.fabric8.api.DataStoreRegistrationHandler;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;

@ThreadSafe
@Component(name="io.fabric8.datastore.template.registry", label="Fabric8 DataStore Manager", immediate=true, metatype=false)
@Service(value={DataStoreRegistrationHandler.class})
public final class DataStoreTemplateRegistry
extends AbstractComponent
implements DataStoreRegistrationHandler {
    private final AtomicReference<DataStoreTemplate> registrationCallbacks = new AtomicReference();

    public String toString() {
        return "DataStoreTemplateRegistry{callback=" + this.registrationCallbacks.get() + '}';
    }

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void setRegistrationCallback(DataStoreTemplate template) {
        this.assertValid();
        if (!this.registrationCallbacks.compareAndSet(null, template)) {
            throw new IllegalStateException("Template already set");
        }
    }

    public DataStoreTemplate removeRegistrationCallback() {
        this.assertValid();
        return this.registrationCallbacks.getAndSet(null);
    }
}

