/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineService;
import org.apache.karaf.shell.console.OsgiCommandSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaasCommandSupport
extends OsgiCommandSupport {
    public static final String JAAS_REALM = "JaasCommand.REALM";
    public static final String JAAS_ENTRY = "JaasCommand.ENTRY";
    public static final String JAAS_CMDS = "JaasCommand.COMMANDS";
    private List<JaasRealm> realms;
    protected BackingEngineService backingEngineService;

    protected abstract Object doExecute(BackingEngine var1) throws Exception;

    protected Object doExecute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get(JAAS_REALM);
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get(JAAS_ENTRY);
        Queue commandQueue = (Queue)this.session.get(JAAS_CMDS);
        if (realm != null && entry != null) {
            if (commandQueue != null) {
                commandQueue.add(this);
            }
        } else {
            System.err.println("No JAAS Realm / Module has been selected.");
        }
        return null;
    }

    public List<JaasRealm> findRealmsByName(String realmName) {
        LinkedList<JaasRealm> realmList = new LinkedList<JaasRealm>();
        for (JaasRealm realm : this.realms) {
            if (!realm.getName().equals(realmName)) continue;
            realmList.add(realm);
        }
        return realmList;
    }

    public Map<AppConfigurationEntry, JaasRealm> findEntries(String realmName, String moduleName, int index) {
        LinkedHashMap<AppConfigurationEntry, JaasRealm> entries = new LinkedHashMap<AppConfigurationEntry, JaasRealm>();
        Map<AppConfigurationEntry, JaasRealm> appConfigurationEntries = this.findEntries();
        int i = 1;
        for (AppConfigurationEntry entry : appConfigurationEntries.keySet()) {
            JaasRealm realm = appConfigurationEntries.get(entry);
            String moduleClass = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
            if (realmName != null && !realmName.equals(realm.getName())) {
                ++i;
                continue;
            }
            if (moduleName != null && !moduleName.equals(entry.getLoginModuleName()) && !moduleName.equals(moduleClass)) {
                ++i;
                continue;
            }
            if (index != 0 && index != i) {
                ++i;
                continue;
            }
            ++i;
            entries.put(entry, realm);
        }
        return entries;
    }

    public Map<AppConfigurationEntry, JaasRealm> findEntries() {
        LinkedHashMap<AppConfigurationEntry, JaasRealm> appConfigurationEntries = new LinkedHashMap<AppConfigurationEntry, JaasRealm>();
        for (JaasRealm realm : this.realms) {
            AppConfigurationEntry[] configurationEntries = realm.getEntries();
            if (configurationEntries == null) continue;
            for (AppConfigurationEntry configurationEntry : configurationEntries) {
                appConfigurationEntries.put(configurationEntry, realm);
            }
        }
        return appConfigurationEntries;
    }

    public List<JaasRealm> getRealms() {
        return this.realms;
    }

    public void setRealms(List<JaasRealm> realms) {
        this.realms = realms;
    }

    public BackingEngineService getBackingEngineService() {
        return this.backingEngineService;
    }

    public void setBackingEngineService(BackingEngineService backingEngineService) {
        this.backingEngineService = backingEngineService;
    }
}

