/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.deployer.dto;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.insight.log.support.Strings;

public class DependencyDTO {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type;
    private String scope;
    private boolean optional;
    private List<DependencyDTO> children = new ArrayList<DependencyDTO>();

    public String toString() {
        return "DependencyDTO{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", classifier='" + this.classifier + '\'' + ", type='" + this.type + '\'' + ", scope='" + this.scope + '\'' + '}';
    }

    public void addChild(DependencyDTO childDTO) {
        this.children.add(childDTO);
    }

    public String toBundleUrlWithoutVersion() {
        String prefix = "mvn:";
        if ("war".equals(this.type)) {
            prefix = "war:" + prefix;
        } else if (!"bundle".equals(this.type) && (Strings.isEmpty((String)this.type) || "jar".equals(this.type))) {
            prefix = "fab:" + prefix;
        }
        return prefix + this.groupId + "/" + this.artifactId + "/";
    }

    public String toBundleUrl() {
        return this.toBundleUrlWithoutVersion() + this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public List<DependencyDTO> getChildren() {
        return this.children;
    }

    public void setChildren(List<DependencyDTO> children) {
        this.children = children;
    }
}

