/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.internal.ConfigurationImpl;
import org.ops4j.pax.web.service.internal.DefaultPropertyResolver;
import org.ops4j.pax.web.service.internal.EventAdminHandler;
import org.ops4j.pax.web.service.internal.HttpServiceFactoryImpl;
import org.ops4j.pax.web.service.internal.HttpServiceProxy;
import org.ops4j.pax.web.service.internal.HttpServiceStarted;
import org.ops4j.pax.web.service.internal.LogServiceHandler;
import org.ops4j.pax.web.service.internal.ServletEventDispatcher;
import org.ops4j.pax.web.service.internal.util.SupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.FallbackPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ServerController serverController;
    private ServiceRegistration<?> httpServiceFactoryReg;
    private BundleContext bundleContext;
    private ServletEventDispatcher servletEventDispatcher;
    private ServiceTracker<EventAdmin, EventAdmin> eventServiceTracker;
    private ServiceTracker<LogService, LogService> logServiceTracker;
    private ServiceTracker<ServerControllerFactory, ServerControllerFactory> dynamicsServiceTracker;
    private final ExecutorService configExecutor = new ThreadPoolExecutor(0, 1, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private Dictionary<String, ?> config;
    private ServerControllerFactory factory;
    private boolean initialConfigSet;

    public void start(BundleContext bundleContext) throws Exception {
        LOG.debug("Starting Pax Web");
        this.bundleContext = bundleContext;
        this.servletEventDispatcher = new ServletEventDispatcher(bundleContext);
        if (SupportUtils.isEventAdminAvailable()) {
            Filter filterEvent = bundleContext.createFilter("(objectClass=org.osgi.service.event.EventAdmin)");
            EventAdminHandler adminHandler = new EventAdminHandler(bundleContext);
            this.eventServiceTracker = new ServiceTracker(bundleContext, filterEvent, (ServiceTrackerCustomizer)adminHandler);
            this.eventServiceTracker.open();
            bundleContext.registerService(ServletListener.class, (Object)adminHandler, null);
            LOG.info("EventAdmin support enabled, servlet events will be postet to topics.");
        } else {
            LOG.info("EventAdmin support is not available, no servlet events will be posted!");
        }
        if (SupportUtils.isLogServiceAvailable()) {
            Filter filterLog = bundleContext.createFilter("(objectClass=org.osgi.service.log.LogService)");
            LogServiceHandler logServiceHandler = new LogServiceHandler(bundleContext);
            this.logServiceTracker = new ServiceTracker(bundleContext, filterLog, (ServiceTrackerCustomizer)logServiceHandler);
            this.logServiceTracker.open();
            bundleContext.registerService(ServletListener.class, (Object)logServiceHandler, null);
            LOG.info("LogService support enabled, log events will be created.");
        } else {
            LOG.info("LogService support is not available, no log events will be created!");
        }
        if (SupportUtils.isManagedServiceAvailable()) {
            this.createManagedService(bundleContext);
        } else {
            this.scheduleUpdateConfig(null);
        }
        LOG.info("Pax Web started");
    }

    public void stop(BundleContext bundleContext) {
        LOG.debug("Stopping Pax Web...");
        if (this.dynamicsServiceTracker != null) {
            this.dynamicsServiceTracker.close();
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
        }
        if (this.eventServiceTracker != null) {
            this.eventServiceTracker.close();
        }
        if (this.servletEventDispatcher != null) {
            this.servletEventDispatcher.destroy();
        }
        try {
            this.configExecutor.shutdown();
            LOG.debug("...entering 20 seconds grace period...");
            this.configExecutor.awaitTermination(20L, TimeUnit.SECONDS);
            this.configExecutor.shutdownNow();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info("Pax Web stopped");
    }

    private void createManagedService(BundleContext bundleContext) {
        ManagedService service = new ManagedService(){

            public void updated(Dictionary<String, ?> config) throws ConfigurationException {
                Activator.this.scheduleUpdateConfig(config);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ops4j.pax.web");
        bundleContext.registerService(ManagedService.class, (Object)service, props);
        if (bundleContext.getServiceReference(ConfigurationAdmin.class.getName()) == null) {
            try {
                service.updated(null);
            }
            catch (ConfigurationException ignore) {
                LOG.error("Internal error. Cannot set initial configuration resolver.", (Throwable)ignore);
            }
        }
    }

    protected boolean same(Dictionary<String, ?> cfg1, Dictionary<String, ?> cfg2) {
        if (cfg1 == null) {
            return cfg2 == null;
        }
        if (cfg2 == null) {
            return false;
        }
        if (cfg1.size() != cfg2.size()) {
            return false;
        }
        boolean result = true;
        Enumeration<String> keys = cfg1.keys();
        while (result && keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object v1 = cfg1.get(key);
            Object v2 = cfg2.get(key);
            result = this.same(v1, v2);
        }
        return result;
    }

    protected boolean same(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1 == v2 || v1.equals(v2);
    }

    private void scheduleUpdateConfig(final Dictionary<String, ?> config) {
        this.configExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Activator.this.updateController(config, Activator.this.factory);
            }
        });
    }

    private void scheduleUpdateFactory(final ServerControllerFactory factory) {
        Future<?> future = this.configExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Activator.this.updateController(Activator.this.config, factory);
            }
        });
        if (factory == null) {
            try {
                future.get(20L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.info("Error when updating factory: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void updateController(Dictionary<String, ?> config, ServerControllerFactory factory) {
        if (!this.initialConfigSet) {
            this.initialConfigSet = true;
            this.config = config;
            this.factory = factory;
            this.dynamicsServiceTracker = new ServiceTracker(this.bundleContext, ServerControllerFactory.class, (ServiceTrackerCustomizer)new DynamicsServiceTrackerCustomizer());
            this.dynamicsServiceTracker.open();
            return;
        }
        if (this.same(config, this.config) && this.same(factory, this.factory)) {
            return;
        }
        if (this.httpServiceFactoryReg != null) {
            this.httpServiceFactoryReg.unregister();
            this.httpServiceFactoryReg = null;
        }
        if (this.serverController != null) {
            this.serverController.stop();
            this.serverController = null;
        }
        if (factory != null) {
            try {
                BundleContextPropertyResolver tmpResolver = new BundleContextPropertyResolver(this.bundleContext, new DefaultPropertyResolver());
                FallbackPropertyResolver resolver = config != null ? new DictionaryPropertyResolver(config, tmpResolver) : tmpResolver;
                ConfigurationImpl configuration = new ConfigurationImpl(resolver);
                final ServerModel serverModel = new ServerModel();
                this.serverController = factory.createServerController(serverModel);
                this.serverController.configure(configuration);
                Dictionary<String, Object> props = this.determineServiceProperties(config, configuration, this.serverController.getHttpPort(), this.serverController.getHttpSecurePort());
                this.httpServiceFactoryReg = this.bundleContext.registerService(new String[]{HttpService.class.getName(), WebContainer.class.getName()}, (Object)new HttpServiceFactoryImpl(){

                    @Override
                    HttpService createService(Bundle bundle) {
                        return new HttpServiceProxy(new HttpServiceStarted(bundle, Activator.this.serverController, serverModel, Activator.this.servletEventDispatcher));
                    }
                }, props);
                if (!this.serverController.isStarted()) {
                    while (!this.serverController.isConfigured()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn("caught interruptexception while waiting for configuration", (Throwable)e);
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    this.serverController.start();
                }
            }
            catch (Throwable t) {
                LOG.error("Unable to start pax web server: " + t.getMessage(), t);
            }
        }
        this.factory = factory;
        this.config = config;
    }

    private Dictionary<String, Object> determineServiceProperties(Dictionary<String, ?> managedConfig, Configuration config, Integer httpPort, Integer httpSecurePort) {
        Hashtable<String, Object> toPropagate = new Hashtable<String, Object>();
        if (managedConfig != null && !managedConfig.isEmpty()) {
            Enumeration<String> enumeration = managedConfig.keys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                toPropagate.put(key, managedConfig.get(key));
            }
        }
        this.setProperty(toPropagate, "org.osgi.service.http.enabled", config.isHttpEnabled());
        this.setProperty(toPropagate, "org.osgi.service.http.port", config.getHttpPort());
        this.setProperty(toPropagate, "org.osgi.service.http.connector.name", config.getHttpConnectorName());
        this.setProperty(toPropagate, "org.osgi.service.http.secure.enabled", config.isHttpSecureEnabled());
        this.setProperty(toPropagate, "org.osgi.service.http.port.secure", config.getHttpSecurePort());
        this.setProperty(toPropagate, "org.osgi.service.http.secure.connector.name", config.getHttpSecureConnectorName());
        this.setProperty(toPropagate, "org.osgi.service.http.useNIO", config.useNIO());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.clientauthneeded", config.isClientAuthNeeded());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.clientauthwanted", config.isClientAuthWanted());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keystore", config.getSslKeystore());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keystore.type", config.getSslKeystoreType());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.password", config.getSslPassword());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keypassword", config.getSslKeyPassword());
        this.setProperty(toPropagate, "javax.servlet.context.tempdir", config.getTemporaryDirectory());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.timeout", config.getSessionTimeout());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.url", config.getSessionUrl());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.cookie", config.getSessionCookie());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.domain", config.getSessionDomain());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.path", config.getSessionPath());
        this.setProperty(toPropagate, "org.ops4j.pax.web.worker.name", config.getWorkerName());
        this.setProperty(toPropagate, "org.ops4j.pax.web.listening.addresses", config.getListeningAddresses());
        this.setProperty(toPropagate, "org.osgi.service.http.port", httpPort);
        this.setProperty(toPropagate, "org.osgi.service.http.port.secure", httpSecurePort);
        this.setProperty(toPropagate, "org.ops4j.pax.web.config.file", config.getConfigurationDir());
        this.setProperty(toPropagate, "org.ops4j.pax.web.config.url", config.getConfigurationURL());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.format", config.getLogNCSAFormat());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.retaindays", config.getLogNCSARetainDays());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.append", config.isLogNCSAAppend());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.extended", config.isLogNCSAExtended());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.dispatch", config.isLogNCSADispatch());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.dispatch", config.isLogNCSADispatch());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.logtimezone", config.getLogNCSATimeZone());
        if (SupportUtils.isJSPAvailable()) {
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.check.interval", config.getJspCheckInterval());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.debug.info", config.getJspClassDebugInfo());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.development", config.getJspDevelopment());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.enable.pooling", config.getJspEnablePooling());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.ie.classid", config.getJspIeClassId());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.java.encoding", config.getJspJavaEncoding());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.keep.generated", config.getJspKeepgenerated());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.log.verbosity.level", config.getJspLogVerbosityLevel());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.mapped.file", config.getJspMappedfile());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.scratch.dir", config.getJspScratchDir());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.tagpool.max.size", config.getJspTagpoolMaxSize());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.precompilation", config.getJspPrecompilation());
        }
        return toPropagate;
    }

    private void setProperty(Hashtable<String, Object> properties, String name, Object value) {
        if (value != null) {
            if (value instanceof File) {
                properties.put(name, ((File)value).getAbsolutePath());
            } else if (value instanceof Object[]) {
                properties.put(name, Activator.join(",", (Object[])value));
            } else {
                properties.put(name, value.toString());
            }
        } else {
            properties.remove(name);
        }
    }

    private static String join(String token, Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < array.length - 1; ++x) {
            if (array[x] != null) {
                sb.append(array[x].toString());
            } else {
                sb.append("null");
            }
            sb.append(token);
        }
        sb.append(array[array.length - 1]);
        return sb.toString();
    }

    private class DynamicsServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServerControllerFactory, ServerControllerFactory> {
        private DynamicsServiceTrackerCustomizer() {
        }

        public ServerControllerFactory addingService(ServiceReference<ServerControllerFactory> reference) {
            ServerControllerFactory factory = (ServerControllerFactory)Activator.this.bundleContext.getService(reference);
            Activator.this.scheduleUpdateFactory(factory);
            return factory;
        }

        public void modifiedService(ServiceReference<ServerControllerFactory> reference, ServerControllerFactory service) {
        }

        public void removedService(ServiceReference<ServerControllerFactory> reference, ServerControllerFactory service) {
            if (Activator.this.bundleContext != null) {
                Activator.this.bundleContext.ungetService(reference);
            }
            Activator.this.scheduleUpdateFactory(null);
        }
    }
}

