/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jmx.FileSystemMBean;
import java.io.File;
import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystem
implements FileSystemMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileSystem.class);
    private ObjectName objectName;
    private final File fs;
    private final String path;

    public FileSystem(RuntimeProperties sysprops) {
        String path;
        this.fs = new File(sysprops.getProperty("karaf.data", "karaf-data"));
        try {
            path = this.fs.getCanonicalPath();
        }
        catch (IOException e) {
            path = this.fs.getAbsolutePath();
        }
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public long getTotalSpace() {
        return this.fs.getTotalSpace();
    }

    @Override
    public long getFreeSpace() {
        return this.fs.getFreeSpace();
    }

    @Override
    public long getUsableSpace() {
        return this.fs.getUsableSpace();
    }

    @Override
    public short getUsedPercentage() {
        long total = this.getTotalSpace();
        long free = this.getFreeSpace();
        return (short)((total - free) * 100L / total);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            this.objectName = new ObjectName("io.fabric8:service=FileSystem");
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getObjectName();
            if (!mbeanServer.isRegistered(name)) {
                mbeanServer.registerMBean(this, name);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.getObjectName();
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }
}

