/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.warmer.WarmerStats;

public class CommonStats
implements Streamable,
ToXContent {
    @Nullable
    DocsStats docs;
    @Nullable
    StoreStats store;
    @Nullable
    IndexingStats indexing;
    @Nullable
    GetStats get;
    @Nullable
    SearchStats search;
    @Nullable
    MergeStats merge;
    @Nullable
    RefreshStats refresh;
    @Nullable
    FlushStats flush;
    @Nullable
    WarmerStats warmer;

    public void add(CommonStats stats) {
        if (this.docs == null) {
            if (stats.docs() != null) {
                this.docs = new DocsStats();
                this.docs.add(stats.docs());
            }
        } else {
            this.docs.add(stats.docs());
        }
        if (this.store == null) {
            if (stats.store() != null) {
                this.store = new StoreStats();
                this.store.add(stats.store());
            }
        } else {
            this.store.add(stats.store());
        }
        if (this.indexing == null) {
            if (stats.indexing() != null) {
                this.indexing = new IndexingStats();
                this.indexing.add(stats.indexing());
            }
        } else {
            this.indexing.add(stats.indexing());
        }
        if (this.get == null) {
            if (stats.get() != null) {
                this.get = new GetStats();
                this.get.add(stats.get());
            }
        } else {
            this.get.add(stats.get());
        }
        if (this.search == null) {
            if (stats.search() != null) {
                this.search = new SearchStats();
                this.search.add(stats.search());
            }
        } else {
            this.search.add(stats.search());
        }
        if (this.merge == null) {
            if (stats.merge() != null) {
                this.merge = new MergeStats();
                this.merge.add(stats.merge());
            }
        } else {
            this.merge.add(stats.merge());
        }
        if (this.refresh == null) {
            if (stats.refresh() != null) {
                this.refresh = new RefreshStats();
                this.refresh.add(stats.refresh());
            }
        } else {
            this.refresh.add(stats.refresh());
        }
        if (this.flush == null) {
            if (stats.flush() != null) {
                this.flush = new FlushStats();
                this.flush.add(stats.flush());
            }
        } else {
            this.flush.add(stats.flush());
        }
        if (this.warmer == null) {
            if (stats.warmer() != null) {
                this.warmer = new WarmerStats();
                this.warmer.add(stats.warmer());
            }
        } else {
            this.warmer.add(stats.warmer());
        }
    }

    @Nullable
    public DocsStats docs() {
        return this.docs;
    }

    @Nullable
    public DocsStats getDocs() {
        return this.docs;
    }

    @Nullable
    public StoreStats store() {
        return this.store;
    }

    @Nullable
    public StoreStats getStore() {
        return this.store;
    }

    @Nullable
    public IndexingStats indexing() {
        return this.indexing;
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.indexing;
    }

    @Nullable
    public GetStats get() {
        return this.get;
    }

    @Nullable
    public GetStats getGet() {
        return this.get;
    }

    @Nullable
    public SearchStats search() {
        return this.search;
    }

    @Nullable
    public SearchStats getSearch() {
        return this.search;
    }

    @Nullable
    public MergeStats merge() {
        return this.merge;
    }

    @Nullable
    public MergeStats getMerge() {
        return this.merge;
    }

    @Nullable
    public RefreshStats refresh() {
        return this.refresh;
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.refresh;
    }

    @Nullable
    public FlushStats flush() {
        return this.flush;
    }

    @Nullable
    public FlushStats getFlush() {
        return this.flush;
    }

    @Nullable
    public WarmerStats warmer() {
        return this.warmer;
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.warmer;
    }

    public static CommonStats readCommonStats(StreamInput in) throws IOException {
        CommonStats stats = new CommonStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.docs = DocsStats.readDocStats(in);
        }
        if (in.readBoolean()) {
            this.store = StoreStats.readStoreStats(in);
        }
        if (in.readBoolean()) {
            this.indexing = IndexingStats.readIndexingStats(in);
        }
        if (in.readBoolean()) {
            this.get = GetStats.readGetStats(in);
        }
        if (in.readBoolean()) {
            this.search = SearchStats.readSearchStats(in);
        }
        if (in.readBoolean()) {
            this.merge = MergeStats.readMergeStats(in);
        }
        if (in.readBoolean()) {
            this.refresh = RefreshStats.readRefreshStats(in);
        }
        if (in.readBoolean()) {
            this.flush = FlushStats.readFlushStats(in);
        }
        if (in.readBoolean()) {
            this.warmer = WarmerStats.readWarmerStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.docs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.docs.writeTo(out);
        }
        if (this.store == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.store.writeTo(out);
        }
        if (this.indexing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.indexing.writeTo(out);
        }
        if (this.get == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.get.writeTo(out);
        }
        if (this.search == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.search.writeTo(out);
        }
        if (this.merge == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.merge.writeTo(out);
        }
        if (this.refresh == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.refresh.writeTo(out);
        }
        if (this.flush == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.flush.writeTo(out);
        }
        if (this.warmer == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.warmer.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.docs != null) {
            this.docs.toXContent(builder, params);
        }
        if (this.store != null) {
            this.store.toXContent(builder, params);
        }
        if (this.indexing != null) {
            this.indexing.toXContent(builder, params);
        }
        if (this.get != null) {
            this.get.toXContent(builder, params);
        }
        if (this.search != null) {
            this.search.toXContent(builder, params);
        }
        if (this.merge != null) {
            this.merge.toXContent(builder, params);
        }
        if (this.refresh != null) {
            this.refresh.toXContent(builder, params);
        }
        if (this.flush != null) {
            this.flush.toXContent(builder, params);
        }
        if (this.warmer != null) {
            this.warmer.toXContent(builder, params);
        }
        return builder;
    }
}

