/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BulkShardRequest
extends ShardReplicationOperationRequest<BulkShardRequest> {
    private int shardId;
    private BulkItemRequest[] items;
    private boolean refresh;

    BulkShardRequest() {
    }

    BulkShardRequest(String index, int shardId, boolean refresh, BulkItemRequest[] items) {
        this.index = index;
        this.shardId = shardId;
        this.items = items;
        this.refresh = refresh;
    }

    boolean refresh() {
        return this.refresh;
    }

    int shardId() {
        return this.shardId;
    }

    BulkItemRequest[] items() {
        return this.items;
    }

    @Override
    public void beforeLocalFork() {
        for (BulkItemRequest item : this.items) {
            ((ShardReplicationOperationRequest)item.request()).beforeLocalFork();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardId);
        out.writeVInt(this.items.length);
        for (BulkItemRequest item : this.items) {
            if (item != null) {
                out.writeBoolean(true);
                item.writeTo(out);
                continue;
            }
            out.writeBoolean(false);
        }
        out.writeBoolean(this.refresh);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = in.readVInt();
        this.items = new BulkItemRequest[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            if (!in.readBoolean()) continue;
            this.items[i] = BulkItemRequest.readBulkItem(in);
        }
        this.refresh = in.readBoolean();
    }
}

