/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.elasticsearch.common.lucene.docset.AllDocSet;

public class NotDocIdSet
extends DocIdSet {
    private final DocIdSet set;
    private final int max;

    public NotDocIdSet(DocIdSet set, int max) {
        this.max = max;
        this.set = set;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public DocIdSetIterator iterator() throws IOException {
        DocIdSetIterator it = this.set.iterator();
        if (it == null) {
            return new AllDocSet.AllDocIdSetIterator(this.max);
        }
        return new NotDocIdSetIterator(this.max, it);
    }

    public static class NotDocIdSetIterator
    extends DocIdSetIterator {
        private final int max;
        private DocIdSetIterator it1;
        int lastReturn = -1;
        private int innerDocid = -1;

        NotDocIdSetIterator(int max, DocIdSetIterator it) throws IOException {
            this.max = max;
            this.it1 = it;
            this.innerDocid = this.it1.nextDoc();
            if (this.innerDocid == Integer.MAX_VALUE) {
                this.it1 = null;
            }
        }

        @Override
        public int docID() {
            return this.lastReturn;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(0);
        }

        @Override
        public int advance(int target) throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (target <= this.lastReturn) {
                target = this.lastReturn + 1;
            }
            if (this.it1 != null && this.innerDocid < target && (this.innerDocid = this.it1.advance(target)) == Integer.MAX_VALUE) {
                this.it1 = null;
            }
            while (this.it1 != null && this.innerDocid == target) {
                if (++target >= this.max) {
                    this.lastReturn = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.innerDocid = this.it1.advance(target);
                if (this.innerDocid != Integer.MAX_VALUE) continue;
                this.it1 = null;
            }
            if (target >= this.max) {
                this.lastReturn = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }
    }
}

