/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.deletionpolicy;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.IndexCommitDelegate;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;

public class SnapshotIndexCommit
extends IndexCommitDelegate
implements Releasable {
    private final SnapshotDeletionPolicy deletionPolicy;
    private final String[] files;

    SnapshotIndexCommit(SnapshotDeletionPolicy deletionPolicy, IndexCommit cp) throws IOException {
        super(cp);
        this.deletionPolicy = deletionPolicy;
        ArrayList<String> tmpFiles = new ArrayList<String>();
        for (String o : cp.getFileNames()) {
            tmpFiles.add(o);
        }
        this.files = tmpFiles.toArray(new String[tmpFiles.size()]);
    }

    public String[] getFiles() {
        return this.files;
    }

    @Override
    public boolean release() {
        return this.deletionPolicy.release(this.getVersion());
    }

    @Override
    public void delete() {
        if (!this.deletionPolicy.isHeld(this.getVersion())) {
            this.delegate.delete();
        }
    }
}

