/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.longs;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.trove.list.array.TLongArrayList;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.longs.LongDocFieldData;
import org.elasticsearch.index.field.data.longs.MultiValueLongFieldData;
import org.elasticsearch.index.field.data.longs.SingleValueLongFieldData;
import org.elasticsearch.index.field.data.support.FieldDataLoader;

public abstract class LongFieldData
extends NumericFieldData<LongDocFieldData> {
    static final long[] EMPTY_LONG_ARRAY = new long[0];
    static final MutableDateTime[] EMPTY_DATETIME_ARRAY = new MutableDateTime[0];
    ThreadLocal<ThreadLocals.CleanableValue<MutableDateTime>> dateTimeCache = new ThreadLocal<ThreadLocals.CleanableValue<MutableDateTime>>(){

        @Override
        protected ThreadLocals.CleanableValue<MutableDateTime> initialValue() {
            return new ThreadLocals.CleanableValue<MutableDateTime>(new MutableDateTime(DateTimeZone.UTC));
        }
    };
    protected final long[] values;

    protected LongFieldData(String fieldName, long[] values) {
        super(fieldName);
        this.values = values;
    }

    @Override
    protected long computeSizeInBytes() {
        return 8 * this.values.length + RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    public final long[] values() {
        return this.values;
    }

    public abstract long value(int var1);

    public abstract long[] values(int var1);

    public MutableDateTime date(int docId) {
        MutableDateTime dateTime = this.dateTimeCache.get().get();
        dateTime.setMillis(this.value(docId));
        return dateTime;
    }

    public void date(int docId, MutableDateTime dateTime) {
        dateTime.setMillis(this.value(docId));
    }

    public abstract MutableDateTime[] dates(int var1);

    @Override
    public LongDocFieldData docFieldData(int docId) {
        return (LongDocFieldData)super.docFieldData(docId);
    }

    @Override
    protected LongDocFieldData createFieldData() {
        return new LongDocFieldData(this);
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc) {
        for (int i = 1; i < this.values.length; ++i) {
            proc.onValue(Long.toString(this.values[i]));
        }
    }

    @Override
    public String stringValue(int docId) {
        return Long.toString(docId);
    }

    @Override
    public byte byteValue(int docId) {
        return (byte)this.value(docId);
    }

    @Override
    public short shortValue(int docId) {
        return (short)this.value(docId);
    }

    @Override
    public int intValue(int docId) {
        return (int)this.value(docId);
    }

    @Override
    public long longValue(int docId) {
        return this.value(docId);
    }

    @Override
    public float floatValue(int docId) {
        return this.value(docId);
    }

    @Override
    public double doubleValue(int docId) {
        return this.value(docId);
    }

    @Override
    public FieldDataType type() {
        return FieldDataType.DefaultTypes.LONG;
    }

    public void forEachValue(ValueProc proc) {
        for (int i = 1; i < this.values.length; ++i) {
            proc.onValue(this.values[i]);
        }
    }

    public abstract void forEachValueInDoc(int var1, ValueInDocProc var2);

    public abstract void forEachValueInDoc(int var1, DateValueInDocProc var2);

    public abstract void forEachValueInDoc(int var1, MutableDateTime var2, DateValueInDocProc var3);

    public static LongFieldData load(IndexReader reader, String field) throws IOException {
        return FieldDataLoader.load(reader, field, new LongTypeLoader());
    }

    static class LongTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<LongFieldData> {
        private final TLongArrayList terms = new TLongArrayList();

        LongTypeLoader() {
            this.terms.add(0L);
        }

        @Override
        public void collectTerm(String term) {
            this.terms.add(FieldCache.NUMERIC_UTILS_LONG_PARSER.parseLong(term));
        }

        @Override
        public LongFieldData buildSingleValue(String field, int[] ordinals) {
            return new SingleValueLongFieldData(field, ordinals, this.terms.toArray());
        }

        @Override
        public LongFieldData buildMultiValue(String field, int[][] ordinals) {
            return new MultiValueLongFieldData(field, ordinals, this.terms.toArray());
        }
    }

    public static interface DateValueInDocProc {
        public void onValue(int var1, MutableDateTime var2);
    }

    public static interface ValueInDocProc {
        public void onValue(int var1, long var2);

        public void onMissing(int var1);
    }

    public static interface ValueProc {
        public void onValue(long var1);
    }
}

