/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.util.List;
import org.elasticsearch.search.facet.Facet;

public interface GeoDistanceFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "geo_distance";

    public List<Entry> entries();

    public List<Entry> getEntries();

    public static class Entry {
        double from = Double.NEGATIVE_INFINITY;
        double to = Double.POSITIVE_INFINITY;
        long count;
        long totalCount;
        double total;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        boolean foundInDoc = false;

        Entry() {
        }

        public Entry(double from, double to, long count, long totalCount, double total, double min, double max) {
            this.from = from;
            this.to = to;
            this.count = count;
            this.totalCount = totalCount;
            this.total = total;
            this.min = min;
            this.max = max;
        }

        public double from() {
            return this.from;
        }

        public double getFrom() {
            return this.from();
        }

        public double to() {
            return this.to;
        }

        public double getTo() {
            return this.to();
        }

        public long count() {
            return this.count;
        }

        public long getCount() {
            return this.count();
        }

        public long totalCount() {
            return this.totalCount;
        }

        public long getTotalCount() {
            return this.totalCount;
        }

        public double total() {
            return this.total;
        }

        public double getTotal() {
            return this.total();
        }

        public double mean() {
            if (this.totalCount == 0L) {
                return 0.0;
            }
            return this.total / (double)this.totalCount;
        }

        public double getMean() {
            return this.mean();
        }

        public double min() {
            return this.min;
        }

        public double getMin() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public double getMax() {
            return this.max;
        }
    }
}

