/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.trove.iterator.TObjectIntIterator;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class FieldsTermsStringFacetCollector
extends AbstractFacetCollector {
    private final FieldDataCache fieldDataCache;
    private final String[] indexFieldsNames;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final FieldDataType[] fieldsDataType;
    private FieldData[] fieldsData;
    private final StaticAggregatorValueProc aggregator;
    private final SearchScript script;

    public FieldsTermsStringFacetCollector(String facetName, String[] fieldsNames, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<String> excluded, Pattern pattern, String scriptLang, String script, Map<String, Object> params) {
        super(facetName);
        int i;
        this.fieldDataCache = context.fieldDataCache();
        this.size = size;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        this.fieldsDataType = new FieldDataType[fieldsNames.length];
        this.fieldsData = new FieldData[fieldsNames.length];
        this.indexFieldsNames = new String[fieldsNames.length];
        for (i = 0; i < fieldsNames.length; ++i) {
            MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(fieldsNames[i]);
            if (smartMappers == null || !smartMappers.hasMapper()) {
                this.indexFieldsNames[i] = fieldsNames[i];
                this.fieldsDataType[i] = FieldDataType.DefaultTypes.STRING;
                continue;
            }
            this.indexFieldsNames[i] = smartMappers.mapper().names().indexName();
            this.fieldsDataType[i] = smartMappers.mapper().fieldDataType();
        }
        this.script = script != null ? context.scriptService().search(context.lookup(), scriptLang, script, params) : null;
        this.aggregator = excluded.isEmpty() && pattern == null && this.script == null ? new StaticAggregatorValueProc(CacheRecycler.<String>popObjectIntMap()) : new AggregatorValueProc(CacheRecycler.<String>popObjectIntMap(), excluded, pattern, this.script);
        if (allTerms) {
            try {
                for (i = 0; i < fieldsNames.length; ++i) {
                    for (IndexReader reader : context.searcher().subReaders()) {
                        FieldData fieldData = this.fieldDataCache.cache(this.fieldsDataType[i], reader, this.indexFieldsNames[i]);
                        fieldData.forEachValue(this.aggregator);
                    }
                }
            }
            catch (Exception e) {
                throw new FacetPhaseExecutionException(facetName, "failed to load all terms", e);
            }
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.script != null) {
            this.script.setScorer(scorer);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        for (int i = 0; i < this.indexFieldsNames.length; ++i) {
            this.fieldsData[i] = this.fieldDataCache.cache(this.fieldsDataType[i], reader, this.indexFieldsNames[i]);
        }
        if (this.script != null) {
            this.script.setNextReader(reader);
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        for (FieldData fieldData : this.fieldsData) {
            fieldData.forEachValueInDoc(doc, this.aggregator);
        }
    }

    @Override
    public Facet facet() {
        TObjectIntHashMap<String> facets = this.aggregator.facets();
        if (facets.isEmpty()) {
            CacheRecycler.pushObjectIntMap(facets);
            return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalStringTermsFacet.StringEntry>of(), this.aggregator.missing(), this.aggregator.total());
        }
        if (this.size < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.size, this.comparatorType.comparator());
            TObjectIntIterator<String> it = facets.iterator();
            while (it.hasNext()) {
                it.advance();
                ordered.insertWithOverflow(new InternalStringTermsFacet.StringEntry(it.key(), it.value()));
            }
            InternalStringTermsFacet.StringEntry[] list = new InternalStringTermsFacet.StringEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalStringTermsFacet.StringEntry)ordered.pop();
            }
            CacheRecycler.pushObjectIntMap(facets);
            return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, Arrays.asList(list), this.aggregator.missing(), this.aggregator.total());
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size);
        TObjectIntIterator<String> it = facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalStringTermsFacet.StringEntry(it.key(), it.value()));
        }
        CacheRecycler.pushObjectIntMap(facets);
        return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, ordered, this.aggregator.missing(), this.aggregator.total());
    }

    public static class StaticAggregatorValueProc
    implements FieldData.StringValueInDocProc,
    FieldData.StringValueProc {
        private final TObjectIntHashMap<String> facets;
        private int missing;
        private int total;

        public StaticAggregatorValueProc(TObjectIntHashMap<String> facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(String value) {
            this.facets.putIfAbsent(value, 0);
        }

        @Override
        public void onValue(int docId, String value) {
            this.facets.adjustOrPutValue(value, 1, 1);
            ++this.total;
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final TObjectIntHashMap<String> facets() {
            return this.facets;
        }

        public final int missing() {
            return this.missing;
        }

        public final int total() {
            return this.total;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final ImmutableSet<String> excluded;
        private final Matcher matcher;
        private final SearchScript script;

        public AggregatorValueProc(TObjectIntHashMap<String> facets, ImmutableSet<String> excluded, Pattern pattern, SearchScript script) {
            super(facets);
            this.excluded = excluded;
            this.matcher = pattern != null ? pattern.matcher("") : null;
            this.script = script;
        }

        @Override
        public void onValue(int docId, String value) {
            if (this.excluded != null && this.excluded.contains(value)) {
                return;
            }
            if (this.matcher != null && !this.matcher.reset(value).matches()) {
                return;
            }
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = scriptValue.toString();
                }
            }
            super.onValue(docId, value);
        }
    }
}

