/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCommand
implements Command,
Runnable,
FileSystemAware {
    protected static final Logger log = LoggerFactory.getLogger(ScpCommand.class);
    protected String name;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optD;
    protected boolean optP;
    protected FileSystemView root;
    protected String path;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ExitCallback callback;
    protected IOException error;

    public ScpCommand(String command) {
        this.name = command;
        log.debug("Executing command {}", (Object)command);
        String[] args = command.split(" ");
        for (int i = 1; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                block8: for (int j = 1; j < args[i].length(); ++j) {
                    switch (args[i].charAt(j)) {
                        case 'f': {
                            this.optF = true;
                            continue block8;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block8;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block8;
                        }
                        case 't': {
                            this.optT = true;
                            continue block8;
                        }
                        case 'd': {
                            this.optD = true;
                        }
                    }
                }
                continue;
            }
            this.path = command.substring(command.indexOf(args[i - 1]) + args[i - 1].length() + 1);
            if ((!this.path.startsWith("\"") || !this.path.endsWith("\"")) && (!this.path.startsWith("'") || !this.path.endsWith("'"))) break;
            this.path = this.path.substring(1, this.path.length() - 1);
            break;
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set");
        }
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void setFileSystemView(FileSystemView view) {
        this.root = view;
    }

    public void start(Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        new Thread((Runnable)this, "ScpCommand: " + this.name).start();
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int exitValue = 0;
        String exitMessage = null;
        ScpHelper helper = new ScpHelper(this.in, this.out, this.root);
        try {
            try {
                if (this.optT) {
                    helper.receive(this.root.getFile(this.path), this.optR, this.optD, this.optP);
                } else if (this.optF) {
                    helper.send(Collections.singletonList(this.path), this.optR, this.optP);
                } else {
                    throw new IOException("Unsupported mode");
                }
                Object var7_4 = null;
                if (this.callback != null) {
                    this.callback.onExit(exitValue, exitMessage);
                }
            }
            catch (IOException e) {
                try {
                    exitValue = 2;
                    exitMessage = e.getMessage() == null ? "" : e.getMessage();
                    this.out.write(exitValue);
                    this.out.write(exitMessage.getBytes());
                    this.out.write(10);
                    this.out.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                log.info("Error in scp command", (Throwable)e);
                Object var7_5 = null;
                if (this.callback != null) {
                    this.callback.onExit(exitValue, exitMessage);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.callback != null) {
                this.callback.onExit(exitValue, exitMessage);
            }
            throw throwable;
        }
    }
}

