/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousInheritanceAnnotationFinder
extends AnnotationFinder {
    private ExecutorService executor = null;
    private CountDownLatch subclassesLatch = null;
    private CountDownLatch implementationsLatch = null;
    private Collection<CountDownLatch> latchToWait = new ArrayList<CountDownLatch>(2);

    public AsynchronousInheritanceAnnotationFinder(Archive archive, boolean checkRuntimeAnnotation) {
        super(archive, checkRuntimeAnnotation);
    }

    public AsynchronousInheritanceAnnotationFinder(Archive archive) {
        super(archive);
    }

    @Override
    public AnnotationFinder enableFindImplementations() {
        if (this.implementationsLatch == null) {
            this.enableFindSubclasses();
            this.implementationsLatch = new CountDownLatch(1);
            this.executor().submit(new Runnable(){

                public void run() {
                    try {
                        AsynchronousInheritanceAnnotationFinder.this.subclassesLatch.await();
                        AsynchronousInheritanceAnnotationFinder.super.enableFindImplementations();
                        AsynchronousInheritanceAnnotationFinder.this.implementationsLatch.countDown();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.latchToWait.add(this.implementationsLatch);
        }
        return this;
    }

    @Override
    public AnnotationFinder enableFindSubclasses() {
        if (this.subclassesLatch == null) {
            this.subclassesLatch = new CountDownLatch(1);
            this.executor().submit(new Runnable(){

                public void run() {
                    AsynchronousInheritanceAnnotationFinder.super.enableFindSubclasses();
                    AsynchronousInheritanceAnnotationFinder.this.subclassesLatch.countDown();
                }
            });
            this.latchToWait.add(this.subclassesLatch);
        }
        return this;
    }

    @Override
    public <T> List<Class<? extends T>> findSubclasses(Class<T> clazz) {
        if (this.subclassesLatch == null) {
            this.enableFindSubclasses();
        }
        this.join(this.subclassesLatch);
        return super.findSubclasses(clazz);
    }

    @Override
    public <T> List<Class<? extends T>> findImplementations(Class<T> clazz) {
        if (this.implementationsLatch == null) {
            this.enableFindImplementations();
        }
        this.join(this.implementationsLatch);
        return super.findImplementations(clazz);
    }

    private ExecutorService executor() {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
        }
        return this.executor;
    }

    private void join(CountDownLatch latch) {
        if (this.latchToWait.remove(latch)) {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.latchToWait.isEmpty()) {
                this.executor.shutdown();
            }
        }
    }

    protected static class DaemonThreadFactory
    implements ThreadFactory {
        private final String name = "xbean-finder-" + this.hashCode();
        private final ThreadGroup group;
        private final AtomicInteger ids = new AtomicInteger(0);

        protected DaemonThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Thread newThread(Runnable runnable) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(AnnotationFinder.class.getClassLoader());
            try {
                Thread thread = new Thread(this.group, runnable, this.name + " - " + this.ids.incrementAndGet());
                if (!thread.isDaemon()) {
                    thread.setDaemon(true);
                }
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                Thread thread2 = thread;
                return thread2;
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }
}

