/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.mvn;

import io.fabric8.agent.mvn.IntegerVersionSegment;
import io.fabric8.agent.mvn.NullVersionSegment;
import io.fabric8.agent.mvn.SnapshotVersionSegment;
import io.fabric8.agent.mvn.StringVersionSegment;
import io.fabric8.agent.mvn.VersionSegment;
import io.fabric8.agent.utils.NullArgumentException;

public class Version
implements Comparable<Version> {
    private final String m_version;
    private final VersionSegment[] m_segments;

    public Version(String version) {
        NullArgumentException.validateNotEmpty(version, true, "Version");
        this.m_version = version;
        String[] segments = version.split("[\\.-]");
        this.m_segments = new VersionSegment[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            String trimmedSegment = segments[i].trim();
            if ("".equals(trimmedSegment)) {
                this.m_segments[i] = new NullVersionSegment();
                continue;
            }
            if ("SNAPSHOT".equals(trimmedSegment)) {
                this.m_segments[i] = new SnapshotVersionSegment();
                continue;
            }
            try {
                this.m_segments[i] = new IntegerVersionSegment(trimmedSegment);
                continue;
            }
            catch (NumberFormatException ignore) {
                this.m_segments[i] = new StringVersionSegment(trimmedSegment);
            }
        }
    }

    VersionSegment[] getSegments() {
        VersionSegment[] copy = new VersionSegment[this.m_segments.length];
        System.arraycopy(this.m_segments, 0, copy, 0, this.m_segments.length);
        return copy;
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        VersionSegment[] otherSegments = version.getSegments();
        int maxSegments = Math.max(this.m_segments.length, otherSegments.length);
        for (int i = 0; i < maxSegments; ++i) {
            VersionSegment thisSegment = new NullVersionSegment();
            if (i < this.m_segments.length) {
                thisSegment = this.m_segments[i];
            }
            VersionSegment otherSegment = new NullVersionSegment();
            if (i < otherSegments.length) {
                otherSegment = otherSegments[i];
            }
            int compResult = 0;
            if (thisSegment.getClass().isAssignableFrom(otherSegment.getClass())) {
                compResult = thisSegment.compareTo(otherSegment);
            } else if (thisSegment instanceof StringVersionSegment) {
                compResult = thisSegment.compareTo(new StringVersionSegment(otherSegment.toString()));
            } else if (otherSegment instanceof StringVersionSegment) {
                compResult = new StringVersionSegment(thisSegment.toString()).compareTo(otherSegment);
            }
            if (compResult == 0) continue;
            return compResult;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.m_version.equals(((Version)o).m_version);
    }

    public int hashCode() {
        return this.m_version.hashCode();
    }

    public String toString() {
        return this.m_version;
    }
}

