/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.sort;

import io.fabric8.agent.resolver.RequirementImpl;
import io.fabric8.agent.resolver.SimpleFilter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class RequirementSort {
    public Collection<Resource> sort(Collection<Resource> resources) {
        LinkedHashSet<Resource> sorted = new LinkedHashSet<Resource>();
        LinkedHashSet<Resource> visited = new LinkedHashSet<Resource>();
        for (Resource r : resources) {
            this.visit(r, resources, visited, sorted);
        }
        return sorted;
    }

    private void visit(Resource resource, Collection<Resource> resources, Set<Resource> visited, Set<Resource> sorted) {
        if (visited.contains(resource)) {
            return;
        }
        visited.add(resource);
        for (Resource r : this.collectDependencies(resource, resources)) {
            this.visit(r, resources, visited, sorted);
        }
        sorted.add(resource);
    }

    private Set<Resource> collectDependencies(Resource resource, Collection<Resource> allResources) {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        List requirements = resource.getRequirements(null);
        for (Requirement requirement : requirements) {
            boolean isSatisfied = false;
            block1: for (Resource r : result) {
                for (Capability capability : r.getCapabilities(null)) {
                    if (!this.isSatisfied(requirement, capability)) continue;
                    isSatisfied = true;
                    continue block1;
                }
            }
            block3: for (Resource r : allResources) {
                if (isSatisfied) continue;
                for (Capability capability : r.getCapabilities(null)) {
                    if (!this.isSatisfied(requirement, capability)) continue;
                    result.add(r);
                    continue block3;
                }
            }
        }
        return result;
    }

    private boolean isSatisfied(Requirement requirement, Capability capability) {
        RequirementImpl br;
        if (requirement instanceof RequirementImpl) {
            br = (RequirementImpl)requirement;
        } else {
            String filter = (String)requirement.getDirectives().get("filter");
            SimpleFilter sf = filter != null ? SimpleFilter.parse(filter) : new SimpleFilter(null, null, 0);
            br = new RequirementImpl(null, requirement.getNamespace(), requirement.getDirectives(), requirement.getAttributes(), sf);
        }
        return br.matches(capability);
    }
}

