/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.resolver.ShadowList;
import org.apache.felix.resolver.SimpleHostedCapability;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.apache.felix.resolver.WrappedResource;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Candidates {
    public static final int MANDATORY = 0;
    public static final int OPTIONAL = 1;
    public static final int ON_DEMAND = 2;
    private final Set<Resource> m_mandatoryResources;
    private final Map<Capability, Set<Requirement>> m_dependentMap;
    private final Map<Requirement, List<Capability>> m_candidateMap;
    private final Map<Resource, WrappedResource> m_allWrappedHosts;
    private final Map<Resource, Object> m_populateResultCache;
    private boolean m_fragmentsPresent = false;

    private Candidates(Set<Resource> mandatoryResources, Map<Capability, Set<Requirement>> dependentMap, Map<Requirement, List<Capability>> candidateMap, Map<Resource, WrappedResource> wrappedHosts, Map<Resource, Object> populateResultCache, boolean fragmentsPresent) {
        this.m_mandatoryResources = mandatoryResources;
        this.m_dependentMap = dependentMap;
        this.m_candidateMap = candidateMap;
        this.m_allWrappedHosts = wrappedHosts;
        this.m_populateResultCache = populateResultCache;
        this.m_fragmentsPresent = fragmentsPresent;
    }

    public Candidates() {
        this.m_mandatoryResources = new HashSet<Resource>();
        this.m_dependentMap = new HashMap<Capability, Set<Requirement>>();
        this.m_candidateMap = new HashMap<Requirement, List<Capability>>();
        this.m_allWrappedHosts = new HashMap<Resource, WrappedResource>();
        this.m_populateResultCache = new HashMap<Resource, Object>();
    }

    public final void populate(ResolveContext rc, Resource resource, int resolution) throws ResolutionException {
        block7: {
            Object cacheValue = this.m_populateResultCache.get(resource);
            if (cacheValue instanceof ResolutionException) {
                return;
            }
            if (cacheValue instanceof Boolean) {
                return;
            }
            boolean isFragment = Util.isFragment(resource);
            if (!isFragment && rc.getWirings().containsKey(resource)) {
                return;
            }
            if (resolution != 2 || isFragment && this.populateFragmentOndemand(rc, resource)) {
                if (resolution == 0) {
                    this.m_mandatoryResources.add(resource);
                }
                try {
                    this.populateResource(rc, resource);
                }
                catch (ResolutionException ex) {
                    if (resolution != 0) break block7;
                    throw ex;
                }
            }
        }
    }

    private void populateResource(ResolveContext rc, Resource resource) throws ResolutionException {
        Integer cycleCount = null;
        Map<Object, List<Object>> localCandidateMap = null;
        List remainingReqs = null;
        Object[] cacheValue = this.m_populateResultCache.get(resource);
        if (cacheValue instanceof ResolutionException) {
            throw (ResolutionException)cacheValue;
        }
        if (cacheValue instanceof Boolean) {
            return;
        }
        if (cacheValue != null) {
            Integer n = new Integer((Integer)((Object[])cacheValue)[0] + 1);
            ((Object[])cacheValue)[0] = n;
            cycleCount = n;
            localCandidateMap = (Map)((Object[])cacheValue)[1];
            remainingReqs = (List)((Object[])cacheValue)[2];
        }
        if (remainingReqs == null && localCandidateMap == null) {
            cycleCount = new Integer(0);
            localCandidateMap = new HashMap<Requirement, List<Capability>>();
            remainingReqs = new ArrayList(resource.getRequirements(null));
            cacheValue = new Object[]{cycleCount, localCandidateMap, remainingReqs};
            this.m_populateResultCache.put(resource, cacheValue);
        }
        while (!remainingReqs.isEmpty()) {
            Requirement req = (Requirement)remainingReqs.remove(0);
            String resolution = (String)req.getDirectives().get("resolution");
            if (!rc.isEffective(req) || resolution != null && resolution.equals("dynamic")) continue;
            List<Capability> candidates = rc.findProviders(req);
            ResolutionException rethrow = this.processCandidates(rc, resource, candidates);
            Object result = this.m_populateResultCache.get(resource);
            if (result instanceof ResolutionException) {
                throw (ResolutionException)result;
            }
            if (candidates.isEmpty() && !Util.isOptional(req)) {
                String msg = new StringBuffer().append("Unable to resolve ").append(resource).append(": missing requirement ").append(req).toString();
                if (rethrow != null) {
                    msg = new StringBuffer().append(msg).append(" [caused by: ").append(rethrow.getMessage()).append("]").toString();
                }
                rethrow = new ResolutionException(msg, null, Collections.singleton(req));
                this.m_populateResultCache.put(resource, rethrow);
                throw rethrow;
            }
            if (candidates.size() <= 0) continue;
            localCandidateMap.put(req, candidates);
        }
        if (cycleCount > 0) {
            ((Object[])cacheValue)[0] = new Integer(cycleCount - 1);
        } else if (cycleCount == 0) {
            this.m_populateResultCache.put(resource, Boolean.TRUE);
            if (localCandidateMap.size() > 0) {
                this.add(localCandidateMap);
            }
        }
    }

    private boolean populateFragmentOndemand(ResolveContext rc, Resource resource) throws ResolutionException {
        ArrayList remainingReqs = new ArrayList(resource.getRequirements(null));
        Requirement hostReq = null;
        Iterator it = remainingReqs.iterator();
        while (it.hasNext()) {
            Requirement r = (Requirement)it.next();
            if (!r.getNamespace().equals("osgi.wiring.host")) continue;
            hostReq = r;
            it.remove();
            break;
        }
        List<Capability> hosts = rc.findProviders(hostReq);
        Iterator<Capability> it2 = hosts.iterator();
        while (it2.hasNext()) {
            Capability host = it2.next();
            if (this.isPopulated(host.getResource())) continue;
            it2.remove();
        }
        if (hosts.isEmpty()) {
            return false;
        }
        Integer cycleCount = new Integer(-1);
        HashMap<Requirement, List<Capability>> localCandidateMap = new HashMap<Requirement, List<Capability>>();
        localCandidateMap.put(hostReq, hosts);
        this.m_populateResultCache.put(resource, new Object[]{cycleCount, localCandidateMap, remainingReqs});
        return true;
    }

    public void populateDynamic(ResolveContext rc, Resource resource, Requirement req, List<Capability> candidates) throws ResolutionException {
        this.m_mandatoryResources.add(resource);
        this.add(req, candidates);
        ResolutionException rethrow = this.processCandidates(rc, resource, candidates);
        if (candidates.isEmpty()) {
            if (rethrow == null) {
                rethrow = new ResolutionException("Dynamic import failed.", null, Collections.singleton(req));
            }
            throw rethrow;
        }
        this.m_populateResultCache.put(resource, Boolean.TRUE);
    }

    private ResolutionException processCandidates(ResolveContext rc, Resource resource, List<Capability> candidates) {
        ResolutionException rethrow = null;
        HashSet<Capability> fragmentCands = null;
        Iterator<Capability> itCandCap = candidates.iterator();
        while (itCandCap.hasNext()) {
            Capability candCap = itCandCap.next();
            boolean isFragment = Util.isFragment(candCap.getResource());
            if (isFragment) {
                if (fragmentCands == null) {
                    fragmentCands = new HashSet<Capability>();
                }
                fragmentCands.add(candCap);
            }
            if (!isFragment && rc.getWirings().containsKey(candCap.getResource()) || candCap.getResource().equals(resource)) continue;
            try {
                this.populateResource(rc, candCap.getResource());
            }
            catch (ResolutionException ex) {
                if (rethrow == null) {
                    rethrow = ex;
                }
                itCandCap.remove();
            }
        }
        if (fragmentCands != null) {
            for (Capability fragCand : fragmentCands) {
                Wiring wiring = rc.getWirings().get(fragCand.getResource());
                if (wiring == null) continue;
                for (Wire wire : wiring.getRequiredResourceWires(null)) {
                    if (fragCand.getNamespace().equals("osgi.wiring.package") && !rc.getWirings().get(wire.getProvider()).getResourceCapabilities(null).contains(fragCand)) continue;
                    rc.insertHostedCapability(candidates, new WrappedCapability(wire.getCapability().getResource(), fragCand));
                }
            }
        }
        return rethrow;
    }

    public boolean isPopulated(Resource resource) {
        Object value = this.m_populateResultCache.get(resource);
        return value != null && value instanceof Boolean;
    }

    public ResolutionException getResolveException(Resource resource) {
        Object value = this.m_populateResultCache.get(resource);
        return value != null && value instanceof ResolutionException ? (ResolutionException)value : null;
    }

    private void add(Requirement req, List<Capability> candidates) {
        if (req.getNamespace().equals("osgi.wiring.host")) {
            this.m_fragmentsPresent = true;
        }
        this.m_candidateMap.put(req, candidates);
    }

    private void add(Map<Requirement, List<Capability>> candidates) {
        for (Map.Entry<Requirement, List<Capability>> entry : candidates.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public Resource getWrappedHost(Resource r) {
        Resource wrapped = this.m_allWrappedHosts.get(r);
        return wrapped == null ? r : wrapped;
    }

    public List<Capability> getCandidates(Requirement req) {
        return this.m_candidateMap.get(req);
    }

    public void prepare(ResolveContext rc) throws ResolutionException {
        Map<Capability, Map<String, Map<Version, List<Requirement>>>> hostFragments = Collections.EMPTY_MAP;
        if (this.m_fragmentsPresent) {
            hostFragments = this.populateDependents();
        }
        ArrayList<WrappedResource> hostResources = new ArrayList<WrappedResource>();
        ArrayList<Resource> unselectedFragments = new ArrayList<Resource>();
        for (Map.Entry<Capability, Map<String, Map<Version, List<Requirement>>>> hostEntry : hostFragments.entrySet()) {
            Capability hostCap = hostEntry.getKey();
            Map<String, Map<Version, List<Requirement>>> fragments = hostEntry.getValue();
            ArrayList<Resource> selectedFragments = new ArrayList<Resource>();
            for (Map.Entry<String, Map<Version, List<Requirement>>> fragEntry : fragments.entrySet()) {
                boolean isFirst = true;
                for (Map.Entry<Version, List<Requirement>> versionEntry : fragEntry.getValue().entrySet()) {
                    for (Requirement hostReq : versionEntry.getValue()) {
                        if (isFirst) {
                            selectedFragments.add(hostReq.getResource());
                            isFirst = false;
                            continue;
                        }
                        this.m_dependentMap.get(hostCap).remove(hostReq);
                        List<Capability> hosts = this.m_candidateMap.get(hostReq);
                        hosts.remove(hostCap);
                        if (!hosts.isEmpty()) continue;
                        unselectedFragments.add(hostReq.getResource());
                    }
                }
            }
            WrappedResource wrappedHost = new WrappedResource(hostCap.getResource(), selectedFragments);
            hostResources.add(wrappedHost);
            this.m_allWrappedHosts.put(hostCap.getResource(), wrappedHost);
        }
        for (Resource fragment : unselectedFragments) {
            this.removeResource(fragment, new ResolutionException(new StringBuffer().append("Fragment was not selected for attachment: ").append(fragment).toString()));
        }
        for (WrappedResource hostResource : hostResources) {
            for (Capability c : hostResource.getCapabilities(null)) {
                Capability origCap;
                Set<Requirement> dependents;
                if (c.getNamespace().equals("osgi.wiring.host") || (dependents = this.m_dependentMap.get(origCap = ((HostedCapability)c).getDeclaredCapability())) == null) continue;
                dependents = new HashSet<Requirement>(dependents);
                this.m_dependentMap.put(c, dependents);
                for (Requirement r : dependents) {
                    List<Capability> cands = this.m_candidateMap.get(r);
                    if (!(cands instanceof ShadowList)) {
                        ShadowList<Capability> shadow = new ShadowList<Capability>(cands);
                        this.m_candidateMap.put(r, shadow);
                        cands = shadow;
                    }
                    if (!origCap.getResource().equals(hostResource.getDeclaredResource())) {
                        List<Capability> original = ((ShadowList)cands).getOriginal();
                        int removeIdx = original.indexOf(origCap);
                        if (removeIdx != -1) {
                            original.remove(removeIdx);
                            cands.remove(removeIdx);
                        }
                        int insertIdx = rc.insertHostedCapability(original, new SimpleHostedCapability(hostResource.getDeclaredResource(), origCap));
                        cands.add(insertIdx, c);
                        continue;
                    }
                    int idx = cands.indexOf(origCap);
                    cands.set(idx, c);
                }
            }
            for (Requirement r : hostResource.getRequirements(null)) {
                Requirement origReq = ((WrappedRequirement)r).getDeclaredRequirement();
                List<Capability> cands = this.m_candidateMap.get(origReq);
                if (cands == null) continue;
                this.m_candidateMap.put(r, new ArrayList<Capability>(cands));
                for (Capability cand : cands) {
                    Set<Requirement> dependents = this.m_dependentMap.get(cand);
                    dependents.remove(origReq);
                    dependents.add(r);
                }
            }
        }
        for (Resource resource : this.m_mandatoryResources) {
            if (this.isPopulated(resource)) continue;
            throw this.getResolveException(resource);
        }
    }

    private Map<Capability, Map<String, Map<Version, List<Requirement>>>> populateDependents() {
        HashMap<Capability, Map<String, Map<Version, List<Requirement>>>> hostFragments = new HashMap<Capability, Map<String, Map<Version, List<Requirement>>>>();
        for (Map.Entry<Requirement, List<Capability>> entry : this.m_candidateMap.entrySet()) {
            Requirement req = entry.getKey();
            List<Capability> caps = entry.getValue();
            for (Capability cap : caps) {
                ArrayList<Requirement> actual;
                TreeMap fragmentVersions;
                Set<Requirement> dependents = this.m_dependentMap.get(cap);
                if (dependents == null) {
                    dependents = new HashSet<Requirement>();
                    this.m_dependentMap.put(cap, dependents);
                }
                dependents.add(req);
                if (!req.getNamespace().equals("osgi.wiring.host")) continue;
                String resSymName = Util.getSymbolicName(req.getResource());
                Version resVersion = Util.getVersion(req.getResource());
                HashMap fragments = (HashMap)hostFragments.get(cap);
                if (fragments == null) {
                    fragments = new HashMap();
                    hostFragments.put(cap, fragments);
                }
                if ((fragmentVersions = (TreeMap)fragments.get(resSymName)) == null) {
                    fragmentVersions = new TreeMap(Collections.reverseOrder());
                    fragments.put(resSymName, fragmentVersions);
                }
                if ((actual = (ArrayList<Requirement>)fragmentVersions.get(resVersion)) == null) {
                    actual = new ArrayList<Requirement>();
                    fragmentVersions.put(resVersion, actual);
                }
                actual.add(req);
            }
        }
        return hostFragments;
    }

    private void removeResource(Resource resource, ResolutionException ex) throws ResolutionException {
        this.m_populateResultCache.put(resource, ex);
        HashSet<Resource> unresolvedResources = new HashSet<Resource>();
        this.remove(resource, unresolvedResources);
        while (!unresolvedResources.isEmpty()) {
            Iterator it = unresolvedResources.iterator();
            resource = (Resource)it.next();
            it.remove();
            this.remove(resource, unresolvedResources);
        }
    }

    private void remove(Resource resource, Set<Resource> unresolvedResources) throws ResolutionException {
        for (Requirement r : resource.getRequirements(null)) {
            this.remove(r);
        }
        for (Capability c : resource.getCapabilities(null)) {
            this.remove(c, unresolvedResources);
        }
    }

    private void remove(Requirement req) {
        boolean isFragment = req.getNamespace().equals("osgi.wiring.host");
        List<Capability> candidates = this.m_candidateMap.remove(req);
        if (candidates != null) {
            for (Capability cap : candidates) {
                Set<Requirement> dependents = this.m_dependentMap.get(cap);
                if (dependents == null) continue;
                dependents.remove(req);
            }
        }
    }

    private void remove(Capability c, Set<Resource> unresolvedResources) throws ResolutionException {
        Set<Requirement> dependents = this.m_dependentMap.remove(c);
        if (dependents != null) {
            for (Requirement r : dependents) {
                List<Capability> candidates = this.m_candidateMap.get(r);
                candidates.remove(c);
                if (!candidates.isEmpty()) continue;
                this.m_candidateMap.remove(r);
                if (Util.isOptional(r)) continue;
                String msg = new StringBuffer().append("Unable to resolve ").append(r.getResource()).append(": missing requirement ").append(r).toString();
                this.m_populateResultCache.put(r.getResource(), new ResolutionException(msg, null, Collections.singleton(r)));
                unresolvedResources.add(r.getResource());
            }
        }
    }

    public Candidates copy() {
        HashMap<Capability, Set<Requirement>> dependentMap = new HashMap<Capability, Set<Requirement>>();
        for (Map.Entry<Capability, Set<Requirement>> entry : this.m_dependentMap.entrySet()) {
            HashSet dependents = new HashSet(entry.getValue());
            dependentMap.put(entry.getKey(), dependents);
        }
        HashMap<Requirement, List<Capability>> candidateMap = new HashMap<Requirement, List<Capability>>();
        for (Map.Entry<Requirement, List<Capability>> entry : this.m_candidateMap.entrySet()) {
            ArrayList candidates = new ArrayList(entry.getValue());
            candidateMap.put(entry.getKey(), candidates);
        }
        return new Candidates(this.m_mandatoryResources, dependentMap, candidateMap, this.m_allWrappedHosts, this.m_populateResultCache, this.m_fragmentsPresent);
    }

    public void dump(ResolveContext rc) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Map.Entry<Requirement, List<Capability>> entry : this.m_candidateMap.entrySet()) {
            resources.add(entry.getKey().getResource());
        }
        System.out.println("=== BEGIN CANDIDATE MAP ===");
        for (Resource resource : resources) {
            List<Capability> candidates;
            Wiring wiring = rc.getWirings().get(resource);
            System.out.println(new StringBuffer().append("  ").append(resource).append(" (").append(wiring != null ? "RESOLVED)" : "UNRESOLVED)").toString());
            List<Requirement> reqs = wiring != null ? wiring.getResourceRequirements(null) : resource.getRequirements(null);
            for (Requirement req : reqs) {
                candidates = this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println(new StringBuffer().append("    ").append(req).append(": ").append(candidates).toString());
            }
            reqs = wiring != null ? Util.getDynamicRequirements(wiring.getResourceRequirements(null)) : Util.getDynamicRequirements(resource.getRequirements(null));
            for (Requirement req : reqs) {
                candidates = this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println(new StringBuffer().append("    ").append(req).append(": ").append(candidates).toString());
            }
        }
        System.out.println("=== END CANDIDATE MAP ===");
    }
}

