/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.VersionedDependencyId;
import io.fabric8.fab.osgi.internal.Configuration;
import io.fabric8.fab.osgi.internal.ConfigurationImpl;
import io.fabric8.fab.osgi.internal.FabFacadeSupport;
import io.fabric8.fab.osgi.internal.Versions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.fusesource.common.util.Filter;
import org.fusesource.common.util.Strings;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.graph.Dependency;

public class BundleFabFacade
extends FabFacadeSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(BundleFabFacade.class);
    private final Bundle bundle;
    private Configuration configuration;
    private VersionedDependencyId dependencyId;

    public BundleFabFacade(Bundle bundle) {
        this.bundle = bundle;
        this.configuration = ConfigurationImpl.newInstance();
        this.setResolver(this.configuration.getResolver());
        Dictionary headers = bundle.getHeaders();
        Object fabId = headers.get("FAB-Id");
        String fabIdString = null;
        if (fabId instanceof String) {
            fabIdString = (String)fabId;
        } else {
            Enumeration iter = bundle.findEntries("META-INF", "pom.properties", true);
            while (iter.hasMoreElements()) {
                Object value = iter.nextElement();
                if (!(value instanceof URL)) continue;
                URL url = (URL)value;
                Properties properties = new Properties();
                try {
                    properties.load(url.openStream());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to load Properties for " + url + ". " + e.getMessage(), e);
                }
                String groupId = properties.getProperty("groupId");
                String artifactId = properties.getProperty("artifactId");
                String version = properties.getProperty("version");
                if (!Strings.notEmpty((String)groupId) || !Strings.notEmpty((String)artifactId) || !Strings.notEmpty((String)version)) continue;
                fabIdString = groupId + ":" + artifactId + ":" + version + ":jar";
            }
            if (fabIdString == null) {
                Object bundleName = headers.get("Bundle-SymbolicName");
                Object versionValue = headers.get("Implementation-Version");
                if (bundleName instanceof String && versionValue instanceof String) {
                    String name = bundleName.toString();
                    String version = versionValue.toString();
                    int idx = name.lastIndexOf(46);
                    if (idx > 0) {
                        fabIdString = name.substring(0, idx) + ":" + name.substring(idx + 1, name.length()) + ":" + version + ":jar";
                    }
                }
            }
        }
        if (fabIdString != null) {
            this.dependencyId = VersionedDependencyId.fromString(fabIdString);
        }
        if (this.dependencyId == null) {
            throw new IllegalArgumentException("Bundle is not a FAB as there is no manifest header: FAB-Id");
        }
    }

    @Override
    public DependencyTree collectDependencyTree(boolean offline, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException {
        return this.getResolver().collectDependencies(this.dependencyId, offline, excludeDependencyFilter).getTree();
    }

    @Override
    public File getJarFile() throws IOException {
        String location = this.bundle.getLocation();
        return new File(location);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getProjectDescription() {
        Object value = this.bundle.getHeaders().get("Description");
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public VersionedDependencyId getVersionedDependencyId() throws IOException {
        return this.dependencyId;
    }

    @Override
    public String toVersionRange(String version) {
        String value;
        int digits = 3;
        Object o = this.bundle.getHeaders().get("FAB-Version-Range-Digits");
        if (o instanceof String && Strings.notEmpty((String)(value = (String)o))) {
            try {
                digits = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse manifest header FAB-Version-Range-Digits as a number. Got: '" + value + "' so ignoring it");
            }
            if (digits < 0 || digits > 4) {
                LOG.warn("Invalid value of manifest header FAB-Version-Range-Digits as value " + digits + " is out of range so ignoring it");
                digits = 3;
            }
        }
        return Versions.toVersionRange(version, digits);
    }

    @Override
    public boolean isInstalled(DependencyTree tree) {
        return BundleFabFacade.isInstalled(this.bundle.getBundleContext(), tree);
    }
}

