/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.adapter;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.eventadmin.impl.adapter.AbstractAdapter;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class LogEventAdapter
extends AbstractAdapter
implements ServiceListener {
    private final Object m_lock = new Object();
    private BundleContext m_context;
    private Object m_logListener;

    public LogEventAdapter(BundleContext context, EventAdmin admin) {
        super(admin);
        this.m_context = context;
        try {
            this.m_context.addServiceListener((ServiceListener)this, "(objectClass=org.osgi.service.log.LogReaderService)");
            ServiceReference[] refs = this.m_context.getServiceReferences("org.osgi.service.log.LogReaderService", null);
            if (null != refs) {
                for (int i = 0; i < refs.length; ++i) {
                    LogReaderService logReader = (LogReaderService)this.m_context.getService(refs[i]);
                    if (null == logReader) continue;
                    logReader.addLogListener((LogListener)this.getLogListener());
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    @Override
    public void destroy(BundleContext context) {
        context.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        LogReaderService logReader;
        if (1 == event.getType() && null != (logReader = (LogReaderService)this.m_context.getService(event.getServiceReference()))) {
            logReader.addLogListener((LogListener)this.getLogListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLogListener() {
        Object object = this.m_lock;
        synchronized (object) {
            if (null != this.m_logListener) {
                return this.m_logListener;
            }
            this.m_logListener = new LogListener(){

                public void logged(LogEntry entry) {
                    ServiceReference service;
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    Bundle bundle = entry.getBundle();
                    if (null != bundle) {
                        ((Dictionary)properties).put("bundle.id", new Long(bundle.getBundleId()));
                        String symbolicName = bundle.getSymbolicName();
                        if (null != symbolicName) {
                            ((Dictionary)properties).put("bundle.symbolicName", symbolicName);
                        }
                        ((Dictionary)properties).put("bundle", bundle);
                    }
                    ((Dictionary)properties).put("log.level", new Integer(entry.getLevel()));
                    ((Dictionary)properties).put("message", entry.getMessage());
                    ((Dictionary)properties).put("timestamp", new Long(entry.getTime()));
                    ((Dictionary)properties).put("log.entry", entry);
                    Throwable exception = entry.getException();
                    if (null != exception) {
                        ((Dictionary)properties).put("exception.class", exception.getClass().getName());
                        String message = exception.getMessage();
                        if (null != message) {
                            ((Dictionary)properties).put("exception.message", message);
                        }
                        ((Dictionary)properties).put("exception", exception);
                    }
                    if (null != (service = entry.getServiceReference())) {
                        Object objectClass;
                        Object pid;
                        ((Dictionary)properties).put("service", service);
                        Object id = service.getProperty("service.id");
                        if (null != id) {
                            try {
                                ((Dictionary)properties).put("service.id", new Long(id.toString()));
                            }
                            catch (NumberFormatException ne) {
                                LogWrapper.getLogger().log(entry.getServiceReference(), 2, "Exception parsing service.id=" + id, ne);
                            }
                        }
                        if (null != (pid = service.getProperty("service.pid"))) {
                            ((Dictionary)properties).put("service.pid", pid.toString());
                        }
                        if (null != (objectClass = service.getProperty("objectClass"))) {
                            if (objectClass instanceof String[]) {
                                ((Dictionary)properties).put("service.objectClass", objectClass);
                            } else {
                                ((Dictionary)properties).put("service.objectClass", new String[]{objectClass.toString()});
                            }
                        }
                    }
                    StringBuffer topic = new StringBuffer(LogEntry.class.getName().replace('.', '/')).append('/');
                    switch (entry.getLevel()) {
                        case 1: {
                            topic.append("LOG_ERROR");
                            break;
                        }
                        case 2: {
                            topic.append("LOG_WARNING");
                            break;
                        }
                        case 3: {
                            topic.append("LOG_INFO");
                            break;
                        }
                        case 4: {
                            topic.append("LOG_DEBUG");
                            break;
                        }
                        default: {
                            topic.append("LOG_OTHER");
                        }
                    }
                    try {
                        LogEventAdapter.this.getEventAdmin().postEvent(new Event(topic.toString(), (Dictionary<String, ?>)properties));
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
            };
            return this.m_logListener;
        }
    }
}

